/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.nio.ChannelConcurrentInvocationCounter;
import com.wily.introscope.agent.trace.nio.SocketAcceptMappingTracer;
import com.wily.introscope.agent.trace.nio.SocketChannelMap;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.nio.channels.SocketChannel;

public final class SocketConcurrentInvocationCounter
extends ChannelConcurrentInvocationCounter {
    public SocketConcurrentInvocationCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (SocketAcceptMappingTracer.checkWithOverheadMgr()) {
            return null;
        }
        if (data.isSocketClamped()) {
            return null;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof SocketChannel) {
            String formattedName;
            SocketChannel channel = (SocketChannel)invocationObject;
            if (SocketChannelMap.isRequired(channel, this.getAgent()) && (formattedName = this.formatParameterizedName(data)) != null) {
                return this.allocateTracer(data, formattedName);
            }
        } else {
            Assertion.wilyAssert("Instrumentation error: invocation object not a SocketChannel");
        }
        return null;
    }
}

