/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.client.transport.websocket;

import com.wily.isengard.client.transport.websocket.WebSocketAdapter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.CharsetUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;

public class WebSocketClientNettyHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClientHandshaker handshaker;
    private final WebSocketAdapter adapter;
    private ChannelPromise handshakeFuture;
    private final IModuleFeedbackChannel feedback;
    private final Module module;
    private ChannelHandlerContext context;
    private static volatile AtomicInteger attemptCount = new AtomicInteger(0);
    private static final int maxErrorLogCount = 10;

    public WebSocketClientNettyHandler(WebSocketClientHandshaker handshaker, WebSocketAdapter adapter) {
        this.handshaker = handshaker;
        this.adapter = adapter;
        this.feedback = adapter.getFeedbackChannel();
        this.module = adapter.getModule();
        attemptCount.incrementAndGet();
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.context = ctx;
        this.handshaker.handshake(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.feedback.debug(this.module, "WebSocket socket channel closed.");
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure((Throwable)new WebSocketHandshakeException("WebSocket socket channel closed before handshake completed."));
        }
        this.adapter.onClose();
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            try {
                this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
                this.feedback.info(this.module, "WebSocket handshake complete.");
                this.handshakeFuture.setSuccess();
                attemptCount.set(0);
            }
            catch (WebSocketHandshakeException e) {
                if (attemptCount.get() < 10) {
                    this.feedback.error(this.module, "WebSocket handshake failed:" + e.getMessage());
                }
                this.feedback.debug(this.module, "WebSocketHandshakeException: ", (Throwable)e);
                this.handshakeFuture.setFailure((Throwable)e);
            }
            return;
        }
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
        }
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
                this.feedback.debug(this.module, "Received unexpected text from server: " + textFrame.text());
            } else if (frame instanceof PongWebSocketFrame) {
                this.feedback.debug(this.module, "WebSocket Client received pong.");
            } else if (frame instanceof BinaryWebSocketFrame) {
                BinaryWebSocketFrame bf = (BinaryWebSocketFrame)frame;
                ByteBuf data = bf.content();
                this.adapter.onMessage(data.nioBuffer());
            } else if (frame instanceof CloseWebSocketFrame) {
                CloseWebSocketFrame cf = (CloseWebSocketFrame)frame;
                this.feedback.info(this.module, "WebSocket Client closed by server with code=" + cf.statusCode() + ", " + cf.reasonText());
                ch.close();
                this.adapter.onClose();
            }
            return;
        }
        this.feedback.debug(this.module, "Received unknown message type from websocket channel.");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (attemptCount.get() < 10) {
            this.feedback.error(this.module, "WebSocket Client caught " + cause.getClass().getName() + ": " + cause.getMessage());
        }
        this.feedback.debug(this.module, "Exception caught: ", cause);
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
        this.adapter.onClose();
    }

    public boolean isOpen() {
        return this.context.channel().isOpen() && this.handshaker.isHandshakeComplete();
    }

    public void close() {
        this.context.channel().close();
    }

    public void send(ByteBuf data) {
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(data);
        this.context.writeAndFlush((Object)frame);
    }

    public InetAddress getInetAddress() {
        if (this.context == null) {
            return null;
        }
        InetSocketAddress addr = (InetSocketAddress)this.context.channel().remoteAddress();
        return addr.getAddress();
    }
}

