/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.apmservices.client.nass.metricbatch;

import com.wily.introscope.agent.apmservices.client.nass.metricbatch.model.MetricData;
import com.wily.introscope.agent.apmservices.client.nass.metricbatch.model.NASSMetric;
import com.wily.introscope.agent.apmservices.client.nass.metricbatch.model.NASSMetricMetadata;
import com.wily.introscope.agent.apmservices.client.nass.metricbatch.model.NASSMetricValue;
import com.wily.introscope.agent.apmservices.client.nass.publisher.model.IngestRecord;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class MetricDataService {
    private IModuleFeedbackChannel logger;
    private String hostProcessName;

    public MetricDataService(IModuleFeedbackChannel logger, String hostProcessName) {
        this.logger = logger;
        this.hostProcessName = hostProcessName;
    }

    public MetricData getMetricBatchEntry(String agentName, AgentMetricData metricData) {
        AgentMetric metric = metricData.getAgentMetric();
        if (metric != null) {
            String attributePath = metric.getAgentMetricPrefix().toString();
            String attributeName = metric.getAttributeName();
            int metricType = metric.getAttributeType();
            long endTime = metricData.getDataValue().getStopTimestampInMillis();
            String value = metricData.getDataValue().getValueAsString();
            int interval = metricData.getFrequency().getPeriodInSeconds();
            NASSMetric metricToRegister = new NASSMetric(this.hostProcessName + agentName, metricType, attributePath + ":" + attributeName);
            NASSMetricMetadata metadata = new NASSMetricMetadata();
            this.updateMetadata(metadata, attributeName, metricType, value);
            if (endTime <= 0L) {
                endTime = (int)(System.currentTimeMillis() / 1000L);
            }
            Object val = NASSMetricValue.getMetricValue(metricType, value, this.logger);
            IngestRecord record = new IngestRecord(null, interval, endTime, val, val, val, 1L);
            return new MetricData(metricToRegister, record, metadata);
        }
        return null;
    }

    private void updateMetadata(NASSMetricMetadata metadata, String attributeName, int type, String value) {
        metadata.put("metric_name", attributeName);
        metadata.put("metric_type", String.valueOf(type));
        metadata.put("metric_unit", value);
        metadata.put("product", "APM");
    }
}

