/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.Utils;
import com.ca.apm.agent.jmxclient.api.JmxConnectionInfo;
import com.ca.apm.agent.jmxclient.api.SSLSettings;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.util.properties.PropertiesUtils;
import java.io.IOException;
import java.util.HashMap;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class ConnectionUtils {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();

    public static JMXConnector getJmxServerConnector(JmxConnectionInfo connInfo) throws IOException {
        boolean useSecureChannel;
        if (connInfo.getHostPort().endsWith(":0")) {
            Logger.logInfoMessage((String)("Found local setting: " + connInfo.getHostPort()));
            return null;
        }
        JMXServiceURL serviceURL = new JMXServiceURL(connInfo.getUrl());
        HashMap<String, Object> env = new HashMap<String, Object>();
        boolean bl = useSecureChannel = connInfo.isSslEnabled() || connInfo.isRegistrySecure();
        if (useSecureChannel) {
            SSLSettings settings = connInfo.getSslSettings();
            SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
            ConnectionUtils.setSystemProperty("javax.net.ssl.trustStore", settings.getTrustStore());
            ConnectionUtils.setSystemPropertyIfValid("javax.net.ssl.trustStorePassword", PropertiesUtils.decryptPassword((String)settings.getTrustStorePassword()));
            ConnectionUtils.setSystemPropertyIfValid("javax.net.ssl.keyStore", settings.getKeyStore());
            ConnectionUtils.setSystemPropertyIfValid("javax.net.ssl.keyStorePassword", PropertiesUtils.decryptPassword((String)settings.getKeyStorePassword()));
            if (connInfo.isSslEnabled()) {
                env.put("jmx.remote.rmi.client.socket.factory", csf);
            }
            if (connInfo.isRegistrySecure()) {
                env.put("com.sun.jndi.rmi.factory.socket", csf);
            }
        }
        if (Utils.isNonEmpty(connInfo.getAuthUserName(), connInfo.getAuthPassword())) {
            String[] credentials = new String[]{connInfo.getAuthUserName(), PropertiesUtils.decryptPassword((String)connInfo.getAuthPassword())};
            env.put("jmx.remote.credentials", credentials);
        }
        return JMXConnectorFactory.connect(serviceURL, env);
    }

    public static void closeJmxServerConnector(JMXConnector connector) {
        LOGGER.logDebugMessage("Closing JMX Connector: " + connector);
        try {
            connector.close();
        }
        catch (IOException e) {
            LOGGER.logDebugMessage("Exception while closing JMX Connector: " + connector, (Throwable)e);
        }
    }

    private static void setSystemProperty(String key, String newValue) {
        String existing = System.getProperty(key);
        if (existing == null) {
            System.setProperty(key, newValue);
        }
    }

    private static void setSystemPropertyIfNotNull(String key, String newValue) {
        if (newValue != null) {
            ConnectionUtils.setSystemProperty(key, newValue);
        }
    }

    private static void setSystemPropertyIfValid(String key, String newValue) {
        if (Utils.isNonEmpty(newValue)) {
            ConnectionUtils.setSystemProperty(key, newValue);
        }
    }
}

