/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.IJMXCustomizer;
import com.wily.introscope.agent.jmx.IntroscopeProtocolAdaptor;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public final class JMXService
implements IAgentService {
    public static final String kIntroscopeJMXSecuritySubjectKey = "com.wily.introscope.jmx.securitysubject";
    public static final String kIntroscopeJMXSecurityClassNameKey = "com.wily.introscope.jmx.security.classname";
    public static final String kIntroscopeJMXPrivelegedMethodNameKey = "com.wily.introscope.jmx.priveleged.methodname";
    public static final String kIntroscopeJMXAccessControllerKey = "com.wily.introscope.jmx.accesscontroller";
    public static final String kIntoscopeJMXUsePlatformMBeanServer = "com.wily.use.platform.mbeanserver";
    public static final String kIntoscopeJMXUsePlatformMBeanServerDescription = "Intoscope_JMX_Use_Platform_MBeanServer_Description";
    private static final Module sModule = new Module("JMXService");

    public final int IAgentService_getServiceVersion() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void IAgentService_startService(IAgent agent, Map parameters) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        IntroscopeProtocolAdaptor theAdaptor;
        agent.IAgent_getModuleFeedback().debug(sModule, "Starting JMXService(parameters=" + parameters);
        IJMXCustomizer customizer = null;
        Object shouldBeSubject = null;
        String securityClassName = null;
        String privelegedMethodName = null;
        AccessControlContext acc = null;
        if (parameters != null) {
            Object obj = parameters.get("IJMXCustomizer-Class");
            if (obj != null) {
                String message;
                IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
                String className = obj.getClass().getName();
                if (obj instanceof IJMXCustomizer) {
                    customizer = (IJMXCustomizer)obj;
                    message = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_JMX_Customizer_Class_Name_Message", className);
                    agent.IAgent_getModuleFeedback().info(sModule, message);
                } else {
                    message = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_JMX_Customizer_Class_Name_Error_Message", className);
                    agent.IAgent_getModuleFeedback().error(sModule, message);
                }
            }
            shouldBeSubject = parameters.get(kIntroscopeJMXSecuritySubjectKey);
            obj = parameters.get(kIntroscopeJMXAccessControllerKey);
            if (obj != null) {
                if (obj instanceof AccessControlContext) {
                    acc = (AccessControlContext)obj;
                    agent.IAgent_getModuleFeedback().debug(sModule, "Using java.security.AccessControlContext: " + acc);
                } else {
                    agent.IAgent_getModuleFeedback().error(sModule, "Not an instance of java.security.AccessControlContext: " + acc);
                }
            }
            securityClassName = (String)parameters.get(kIntroscopeJMXSecurityClassNameKey);
            privelegedMethodName = (String)parameters.get(kIntroscopeJMXPrivelegedMethodNameKey);
        }
        if ((theAdaptor = IntroscopeProtocolAdaptor.createInstance(agent, customizer, shouldBeSubject, securityClassName, privelegedMethodName, acc)) == null) {
            agent.IAgent_getModuleFeedback().info(sModule, "No new IntroscopeProtocolAdaptor created");
            return;
        }
        theAdaptor.registerHeartbeatBehavior(agent.IAgent_getCommonHeartbeat());
        ClassLoader savedContext = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            MBeanServer wilyServer = null;
            if (this.isUsePlatformMBeanServer(agent)) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = cl.loadClass("java.lang.management.ManagementFactory");
                Method method = clazz.getMethod("getPlatformMBeanServer", null);
                wilyServer = (MBeanServer)method.invoke(null, null);
            } else {
                wilyServer = MBeanServerFactory.createMBeanServer("com.wily.introscope.agent");
            }
            ObjectName name = IntroscopeProtocolAdaptor.getIntroscopeProtocolAdaptorMBeanName();
            wilyServer.registerMBean(theAdaptor, name);
        }
        catch (ClassNotFoundException e) {
            agent.IAgent_getModuleFeedback().error(sModule, "ClassNotFoundException: ", (Throwable)e);
        }
        catch (SecurityException e) {
            agent.IAgent_getModuleFeedback().error(sModule, "SecurityException: ", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            agent.IAgent_getModuleFeedback().error(sModule, "NoSuchMethodException: ", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            agent.IAgent_getModuleFeedback().error(sModule, "IllegalArgumentException: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            agent.IAgent_getModuleFeedback().error(sModule, "IllegalAccessException: ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            agent.IAgent_getModuleFeedback().error(sModule, "InvocationTargetException: ", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedContext);
        }
        agent.IAgent_getModuleFeedback().info(sModule, agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_JMX_JMX_Activated_Message"));
    }

    private boolean isUsePlatformMBeanServer(IAgent agent) {
        BooleanConfigurationProperty property = new BooleanConfigurationProperty(kIntoscopeJMXUsePlatformMBeanServer, Boolean.FALSE, kIntoscopeJMXUsePlatformMBeanServerDescription, false, false, agent.IAgent_getModuleFeedback(), sModule, agent.IAgent_getStringLocalizer());
        agent.IAgent_getConfigurationManager().add((ConfigurationProperty)property);
        return (Boolean)property.getValue();
    }
}

