/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.ext.agentstats;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.ext.agentstats.KProperties;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.util.Map;

public class AgentStats
implements IAgentService,
ITimestampedRunnable {
    public static final String AgentStats = "Agent Stats";
    private IAgent agent;
    private IIntegerFluctuatingCounterDataAccumulator metricCount;
    private boolean turnOnMetricCount = false;

    public int IAgentService_getServiceVersion() {
        return 2;
    }

    public void IAgentService_startService(IAgent anAgent, Map params) throws Exception {
        this.agent = anAgent;
        if (KProperties.propertyIsTrue("introscope.ext.supportability", this.agent.IAgent_getIndexedProperties())) {
            this.turnOnMetricCount = this.agent.IAgent_getIndexedProperties().safeGetBooleanProperty("introscope.ext.agent.metric.count", false, this.agent.IAgent_getModuleFeedback(), this.agent.IAgent_getStringLocalizer());
            if (this.turnOnMetricCount) {
                this.metricCount = this.agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats:Metric Count");
                this.agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this, AgentStats, true, 15000L, true);
                this.agent.IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

                    public void ITimestampedRunnable_execute(long nowInMillis) {
                        try {
                            AgentShim.getAgent().IAgent_getModuleFeedback().info("Number of current, live metrics=" + AgentStats.this.getCurrentNumberOfMetrics());
                        }
                        catch (AgentNotAvailableException e) {
                            AgentShim.handleError((String)"Agent doesn't exist", (Throwable)e);
                        }
                    }
                }, AgentStats, true, 3600000L, false);
            } else {
                this.agent.IAgent_getModuleFeedback().info("The supportability metric -> Metric Count will not be reported since introscope.ext.agent.metric.count is set to false");
            }
            String buildAndRelease = new IntroscopeVersion(this.agent.IAgent_getStringLocalizer()).IVersion_getReleaseAndBuildString(this.agent.IAgent_getStringLocalizer());
            this.agent.IAgent_getDataAccumulatorFactory().safeGetStringConstantDataAccumulator("Agent Stats:Build and Release", buildAndRelease);
        }
    }

    public void ITimestampedRunnable_execute(long arg0) {
        int count = this.getCurrentNumberOfMetrics();
        this.metricCount.IIntegerCounterDataAccumulator_setValue(count);
    }

    int getCurrentNumberOfMetrics() {
        return this.agent.IAgent_getMetricRecordingAdministrator().getMetricCount();
    }
}

