/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.correlation.WSCorrelationTracer;
import com.wily.util.properties.AttributeListing;
import java.util.Iterator;

public class Axis1ServerCorrelationTracer
extends WSCorrelationTracer {
    public Axis1ServerCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        this.logger.debug("Axis1ServerCorrelationTracer.ITracer_finishTrace");
        if (WSMUtils.correlationSOAPReadEnabled() || WSMUtils.correlationHTTPReadEnabled()) {
            super.ITracer_finishTrace(tracerIndex, data);
        }
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        boolean correlationIdFound;
        block9: {
            this.logger.debug("Axis1ServerCorrelationTracer.ITracer_startTrace");
            correlationIdFound = false;
            boolean isHTTPReadEnabled = WSMUtils.correlationHTTPReadEnabled();
            try {
                this.readHTTPCorrelationInfo(data, isHTTPReadEnabled, correlationIdFound);
                if (!WSMUtils.correlationSOAPReadEnabled() || correlationIdFound) break block9;
                Object messagecontext = data.getInvocationParameterAsObject(0);
                Object message = WSMUtils.invokeMethodOnObject(messagecontext, "getMessage");
                Object soapPart = WSMUtils.invokeMethodOnObject(message, "getSOAPPart");
                Object envelope = WSMUtils.invokeMethodOnObject(soapPart, "getEnvelope");
                Object soapHeader = WSMUtils.invokeMethodOnObject(envelope, "getHeader");
                Object ele = null;
                if (soapHeader != null) {
                    this.logger.debug("Axis1ServerCorrelationTracer.ITracer_startTrace header !=null");
                    Iterator itr = (Iterator)WSMUtils.invokeMethodOnObject(soapHeader, "getChildElements");
                    while (itr.hasNext()) {
                        ele = itr.next();
                        String eleName = (String)WSMUtils.invokeMethodOnObject(ele, "getLocalName");
                        if (!eleName.equals("WSCorIDSOAPHeader")) continue;
                        if (this.logger != null && this.logger.isDebugEnabled()) {
                            this.logger.debug("Axis1ServerCorrelationTracer::CorId Found.");
                        }
                        correlationIdFound = true;
                        String corrID = (String)WSMUtils.invokeMethodOnObject(ele, "getAttributeValue", new Class[]{String.class}, new Object[]{"CorID"});
                        if (corrID != null && !corrID.equals("")) {
                            CorrelationId correlationIdTmp = new CorrelationId(corrID);
                            correlationIdFound = true;
                        }
                        if (this.logger != null && this.logger.isDebugEnabled()) {
                            this.logger.debug("Axis1ServerCorrelationTracer CorID: " + corrID);
                        }
                        WSMUtils.invokeMethodOnObject(ele, "detachNode");
                        break block9;
                    }
                    break block9;
                }
                this.logger.debug("Axis1ServerCorrelationTracer.ITracer_startTrace header ==null");
            }
            catch (Exception e) {
                WSMUtils.handleException(this.getAgent(), "Axis1ServerCorrelationTracer:ITracer_startTrace", e);
            }
        }
        if (!correlationIdFound) {
            CorrelationId correlationId = new CorrelationId();
        }
        if (WSMUtils.correlationSOAPReadEnabled() || WSMUtils.correlationHTTPReadEnabled()) {
            super.ITracer_startTrace(tracerIndex, data);
        }
    }

    protected void getCorrelationInfoFromHttpHeaders(Object mimeheaders, boolean correlationIdFound) throws Exception {
        String[] corid = (String[])WSMUtils.invokeMethodOnObject(mimeheaders, "getHeader", new Class[]{String.class}, new Object[]{"CorID"});
        if (corid != null && corid.length > 0) {
            if (corid.length > 1) {
                this.logger.info("Axis1ServerCorrelationTracer: multiple Correlation ID values found, the first value will be used");
            }
            CorrelationId correlationIdTmp = new CorrelationId(corid[0]);
            correlationIdFound = true;
        } else {
            CorrelationId correlationId = new CorrelationId();
        }
    }

    protected void readHTTPCorrelationInfo(InvocationData data, boolean isHTTPReadEnabled, boolean correlationIdFound) throws Exception {
        if (isHTTPReadEnabled) {
            Object messageContext = data.getInvocationParameterAsObject(0);
            Object soapMess = WSMUtils.invokeMethodOnObject(messageContext, "getMessage");
            Object mimeheaders = WSMUtils.invokeMethodOnObject(soapMess, "getMimeHeaders");
            this.getCorrelationInfoFromHttpHeaders(mimeheaders, correlationIdFound);
        }
    }
}

