/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.dns.IDnsService;
import com.wily.introscope.agent.trace.nio.ChannelConfiguration;
import com.wily.util.adt.ConcurrentWeakThreadLocalHashMap;
import com.wily.util.adt.IConcurrentMapFactory15;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;

public final class DatagramChannelMap {
    private static AtomicReference<ConcurrentWeakThreadLocalHashMap<DatagramChannel, Map<InetSocketAddress, ChannelInfo>>> sDatagramChannelMapCache = new AtomicReference<Object>(null);

    private static final void initDatagramChannelMapCache() {
        try {
            IAgent agent = AgentShim.getAgent();
            IConcurrentMapFactory15 mapFactory = (IConcurrentMapFactory15)((Object)agent.IAgent_getConcurrentMapFactory());
            ConcurrentWeakThreadLocalHashMap map = mapFactory.getConcurrentWeakHashMap("DatagramChannelMapCache");
            sDatagramChannelMapCache.set(map);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            // empty catch block
        }
    }

    public static final void put(DatagramChannel channel, InetSocketAddress remoteAddress, String resourceName, InetSocketAddress address, boolean isClientConnection) {
        if (channel != null && remoteAddress != null && resourceName != null && address != null) {
            ChannelInfo cInfo;
            Map<InetSocketAddress, ChannelInfo> cMap = DatagramChannelMap.get(channel);
            if (cMap == null) {
                cMap = new WeakHashMap<InetSocketAddress, ChannelInfo>();
                DatagramChannelMap.put(channel, cMap);
            }
            if ((cInfo = cMap.get(remoteAddress)) == null) {
                cMap.put(remoteAddress, new ChannelInfo(resourceName, address, isClientConnection));
            }
        }
    }

    private static final void put(DatagramChannel channel, Map<InetSocketAddress, ChannelInfo> cMap) {
        ConcurrentWeakThreadLocalHashMap<DatagramChannel, Map<InetSocketAddress, ChannelInfo>> map = sDatagramChannelMapCache.get();
        if (map == null) {
            DatagramChannelMap.initDatagramChannelMapCache();
            map = sDatagramChannelMapCache.get();
        }
        if (map != null) {
            map.putWeak(channel, cMap);
        }
    }

    private static final Map<InetSocketAddress, ChannelInfo> get(DatagramChannel channel) {
        ConcurrentWeakThreadLocalHashMap<DatagramChannel, Map<InetSocketAddress, ChannelInfo>> map = sDatagramChannelMapCache.get();
        if (map == null) {
            DatagramChannelMap.initDatagramChannelMapCache();
            map = sDatagramChannelMapCache.get();
        }
        if (map != null) {
            return map.getWeak(channel);
        }
        return null;
    }

    public static final InetSocketAddress getAddress(DatagramChannel channel, InetSocketAddress remoteAddress) {
        ChannelInfo cInfo = DatagramChannelMap.getChannelInfo(channel, remoteAddress);
        if (cInfo != null) {
            return cInfo.getAddress();
        }
        return null;
    }

    public static final int getPort(DatagramChannel channel, InetSocketAddress remoteAddress) {
        InetSocketAddress addr = DatagramChannelMap.getAddress(channel, remoteAddress);
        if (addr != null) {
            return addr.getPort();
        }
        return -1;
    }

    public static final String getHost(DatagramChannel channel, InetSocketAddress remoteAddress) {
        InetSocketAddress addr = DatagramChannelMap.getAddress(channel, remoteAddress);
        if (addr != null) {
            try {
                IAgent agent = AgentShim.getAgent();
                IDnsService dnsService = agent.IAgent_getDnsService();
                return dnsService.getDnsHostNameByIPAddr(addr.getAddress());
            }
            catch (AgentNotAvailableException ex) {
                return addr.getHostName();
            }
            catch (Exception ex) {
                return addr.getHostName();
            }
        }
        return "Unknown Host";
    }

    public static final String getResourceName(DatagramChannel channel, InetSocketAddress remoteAddress) {
        ChannelInfo cInfo = DatagramChannelMap.getChannelInfo(channel, remoteAddress);
        if (cInfo != null) {
            return cInfo.getResourceName();
        }
        return null;
    }

    public static final boolean isClientConnection(DatagramChannel channel, InetSocketAddress remoteAddress) {
        ChannelInfo cInfo = DatagramChannelMap.getChannelInfo(channel, remoteAddress);
        if (cInfo != null) {
            return cInfo.isClientConection();
        }
        return false;
    }

    public static final boolean isRequired(DatagramChannel channel, InetSocketAddress remoteAddress, IAgent agent) {
        if (DatagramChannelMap.isClientConnection(channel, remoteAddress)) {
            return DatagramChannelMap.isClientRequired(channel, remoteAddress, agent);
        }
        return DatagramChannelMap.isServerRequired(channel, remoteAddress, agent);
    }

    public static final boolean isClientRequired(DatagramChannel channel, InetSocketAddress remoteAddress, IAgent agent) {
        ChannelConfiguration cc = ChannelConfiguration.getChannelConfiguration(agent);
        return cc.isRequired(0, remoteAddress.getAddress()) && cc.isRequired(2, remoteAddress.getPort());
    }

    public static final boolean isServerRequired(DatagramChannel channel, InetSocketAddress remoteAddress, IAgent agent) {
        ChannelConfiguration cc = ChannelConfiguration.getChannelConfiguration(agent);
        return cc.isRequired(3, channel.socket().getLocalPort());
    }

    private static final ChannelInfo getChannelInfo(DatagramChannel channel, InetSocketAddress remoteAddress) {
        Map<InetSocketAddress, ChannelInfo> cMap = DatagramChannelMap.get(channel);
        if (cMap != null) {
            return cMap.get(remoteAddress);
        }
        return null;
    }

    private static final class ChannelInfo {
        private final String resourceName;
        private final InetSocketAddress address;
        private final boolean isClientConnection;

        private ChannelInfo(String resourceName, InetSocketAddress address, boolean isClientConnection) {
            this.resourceName = resourceName;
            this.address = address;
            this.isClientConnection = isClientConnection;
        }

        private final String getResourceName() {
            return this.resourceName;
        }

        private final InetSocketAddress getAddress() {
            return this.address;
        }

        private final boolean isClientConection() {
            return this.isClientConnection;
        }
    }
}

