/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.introscope.agent.util.HelperClassLoader;
import com.wily.introscope.agent.util.IHelper;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.concurrent.ConcurrentHashMap;

public class HelperFactory {
    private static final Module sModule = new Module("HelperFactory");
    private static final HelperFactory helperFactory = new HelperFactory();
    private final ConcurrentHashMap<ClassLoader, ConcurrentHashMap<ClassLoader, ClassLoader>> repository = new ConcurrentHashMap();

    public static HelperFactory getInstance() {
        return helperFactory;
    }

    private HelperFactory() {
    }

    public IHelper safeGetHelper(Class<?> helperClass, Object agentObject, Object applicationObject, IModuleFeedbackChannel feedback) {
        ClassLoader agentClassLoader = agentObject.getClass().getClassLoader();
        ClassLoader applicationClassLoader = applicationObject.getClass().getClassLoader();
        return this.safeGetHelper(helperClass, agentClassLoader, applicationClassLoader, feedback);
    }

    public IHelper safeGetHelper(Class<?> helperClass, ClassLoader agentClassLoader, ClassLoader applicationClassLoader, IModuleFeedbackChannel feedback) {
        if (helperClass == null) {
            feedback.warn(sModule, "Helper class null");
            return null;
        }
        return this.safeGetHelper(helperClass.getName(), agentClassLoader, applicationClassLoader, feedback);
    }

    public IHelper safeGetHelper(String name, Object agentObject, Object applicationObject, IModuleFeedbackChannel feedback) {
        if (agentObject == null) {
            feedback.warn(sModule, "Agent object null");
            return null;
        }
        if (applicationObject == null) {
            feedback.warn(sModule, "Application object null");
            return null;
        }
        ClassLoader agentClassLoader = agentObject.getClass().getClassLoader();
        ClassLoader applicationClassLoader = applicationObject.getClass().getClassLoader();
        return this.safeGetHelper(name, agentClassLoader, applicationClassLoader, feedback);
    }

    public IHelper safeGetHelper(String name, ClassLoader agentClassLoader, ClassLoader applicationClassLoader, IModuleFeedbackChannel feedback) {
        block6: {
            ClassLoader classLoader = this.getHelperClassLoader(agentClassLoader, applicationClassLoader, feedback);
            try {
                Class<?> clazz = classLoader.loadClass(name);
                return (IHelper)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                String msg = "Failed to find helper class '" + name + "'";
                feedback.warn(sModule, msg);
                if (feedback.isDebugEnabled(sModule)) {
                    feedback.debug(sModule, msg, e);
                }
            }
            catch (InstantiationException e) {
                String msg = "Failed to instantiate helper class '" + name + "'";
                feedback.warn(sModule, msg);
                if (feedback.isDebugEnabled(sModule)) {
                    feedback.debug(sModule, msg, e);
                }
            }
            catch (IllegalAccessException e) {
                String msg = "Failed to find access class '" + name + "'";
                feedback.warn(sModule, msg);
                if (!feedback.isDebugEnabled(sModule)) break block6;
                feedback.debug(sModule, msg, e);
            }
        }
        return null;
    }

    public IHelper getHelper(Class<?> helperClass, Object agentObject, Object applicationObject, IModuleFeedbackChannel feedback) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (agentObject == null) {
            throw new IllegalArgumentException("Agent object null");
        }
        if (applicationObject == null) {
            throw new IllegalArgumentException("Application object null");
        }
        ClassLoader agentClassLoader = agentObject.getClass().getClassLoader();
        ClassLoader applicationClassLoader = applicationObject.getClass().getClassLoader();
        return this.getHelper(helperClass, agentClassLoader, applicationClassLoader, feedback);
    }

    public IHelper getHelper(Class<?> helperClass, ClassLoader agentClassLoader, ClassLoader applicationClassLoader, IModuleFeedbackChannel feedback) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (helperClass == null) {
            throw new ClassNotFoundException("Helper class null");
        }
        return this.getHelper(helperClass.getName(), agentClassLoader, applicationClassLoader, feedback);
    }

    public IHelper getHelper(String name, Object agentObject, Object applicationObject, IModuleFeedbackChannel feedback) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (agentObject == null) {
            throw new IllegalArgumentException("Agent object null");
        }
        if (applicationObject == null) {
            throw new IllegalArgumentException("Application object null");
        }
        ClassLoader agentClassLoader = agentObject.getClass().getClassLoader();
        ClassLoader applicationClassLoader = applicationObject.getClass().getClassLoader();
        return this.getHelper(name, agentClassLoader, applicationClassLoader, feedback);
    }

    public IHelper getHelper(String name, ClassLoader agentClassLoader, ClassLoader applicationClassLoader, IModuleFeedbackChannel feedback) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassLoader classLoader = this.getHelperClassLoader(agentClassLoader, applicationClassLoader, feedback);
        Class<?> clazz = classLoader.loadClass(name);
        return (IHelper)clazz.newInstance();
    }

    public ClassLoader getHelperClassLoader(Object agentObject, Object applicationObject, IModuleFeedbackChannel feedback) {
        if (agentObject == null) {
            throw new IllegalArgumentException("Agent object null");
        }
        if (applicationObject == null) {
            throw new IllegalArgumentException("Application object null");
        }
        ClassLoader agentClassLoader = agentObject.getClass().getClassLoader();
        ClassLoader applicationClassLoader = applicationObject.getClass().getClassLoader();
        return this.getHelperClassLoader(agentClassLoader, applicationClassLoader, feedback);
    }

    public ClassLoader getHelperClassLoader(ClassLoader agentClassLoader, ClassLoader applicationClassLoader, IModuleFeedbackChannel feedback) {
        ClassLoader existingAgentHelperClassLoaders;
        ClassLoader helperClassLoader;
        ConcurrentHashMap<ClassLoader, ClassLoader> existingAgentHelperClassLoadersrepository;
        if (agentClassLoader == null) {
            return applicationClassLoader;
        }
        if (applicationClassLoader == null) {
            return agentClassLoader;
        }
        ConcurrentHashMap<ClassLoader, ClassLoader> agentHelperClassLoaders = this.repository.get(agentClassLoader);
        if (agentHelperClassLoaders == null && (existingAgentHelperClassLoadersrepository = this.repository.putIfAbsent(agentClassLoader, agentHelperClassLoaders = new ConcurrentHashMap())) != null) {
            agentHelperClassLoaders = existingAgentHelperClassLoadersrepository;
        }
        if ((helperClassLoader = agentHelperClassLoaders.get(applicationClassLoader)) == null && (existingAgentHelperClassLoaders = agentHelperClassLoaders.putIfAbsent(applicationClassLoader, helperClassLoader = new HelperClassLoader(applicationClassLoader, agentClassLoader, feedback))) != null) {
            helperClassLoader = existingAgentHelperClassLoaders;
        }
        return helperClassLoader;
    }

    public void removeExtension(Object agentObject) {
        if (agentObject != null) {
            this.removeExtension(agentObject.getClass().getClassLoader());
        }
    }

    public void removeExtension(ClassLoader agentClassLoader) {
        if (agentClassLoader != null) {
            this.repository.remove(agentClassLoader);
        }
    }

    public void removeHelperClassLoader(Object agentObject, Object applicationObject) {
        if (agentObject == null || applicationObject == null) {
            return;
        }
        ClassLoader agentClassLoader = agentObject.getClass().getClassLoader();
        ClassLoader applicationClassLoader = applicationObject.getClass().getClassLoader();
        this.removeHelperClassLoader(agentClassLoader, applicationClassLoader);
    }

    public void removeHelperClassLoader(ClassLoader agentClassLoader, ClassLoader applicationClassLoader) {
        if (agentClassLoader == null || applicationClassLoader == null) {
            return;
        }
        ConcurrentHashMap<ClassLoader, ClassLoader> agentHelperClassLoaders = this.repository.get(agentClassLoader);
        if (agentHelperClassLoaders != null) {
            agentHelperClassLoaders.remove(applicationClassLoader);
        }
    }

    public void clearRepository() {
        this.repository.clear();
    }
}

