/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feedback.backend.logback;

import ch.qos.logback.core.PropertyDefinerBase;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.util.properties.IndexedProperties;

public class AgentMaxLogFileIndexPropertyDefiner
extends PropertyDefinerBase {
    @Override
    public String getPropertyValue() {
        try {
            IAgent agent = AgentShim.getAgent();
            IndexedProperties props = agent.IAgent_getIndexedProperties();
            String maxLogFileIndex = props.getProperty("introscope.agent.log.max.rollover.index");
            try {
                int maxIndex = Integer.valueOf(maxLogFileIndex);
                if (maxIndex < 1 || maxIndex > 20) {
                    agent.IAgent_getModuleFeedback().warn("Property introscope.agent.log.max.rollover.index value " + maxIndex + " is out of range [1..20]; using default value " + "4" + " instead.");
                    return "4";
                }
            }
            catch (NumberFormatException e) {
                agent.IAgent_getModuleFeedback().warn("Property introscope.agent.log.max.rollover.index value " + maxLogFileIndex + " is not a number; using default value " + "4" + " instead.");
                return "4";
            }
            return maxLogFileIndex;
        }
        catch (AgentNotAvailableException e) {
            return null;
        }
    }
}

