/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.InformationNotAvailableException;
import com.wily.introscope.agent.trace.ICpuUsageReporter;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class MethodCPUTimer
extends ASingleMetricTracerFactory
implements IInvocationDataParameterCallback {
    private static final String CPU_TIME_PARAM_KEY = "CPU Time";
    private static final IUpdater updater = UpdaterFactory.getCombiningUpdater();
    private static boolean isHopeless;
    private static ICpuUsageReporter reporter;

    public MethodCPUTimer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        MethodCPUTimer.getCPUUsageReporter(agent);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        ICpuUsageReporter reporter = MethodCPUTimer.getCPUUsageReporter(this.getAgent());
        if (reporter != null) {
            if (data.getCPUStartTime() < 0L) {
                data.setCPUStartTime(this.getCPUUsage(reporter));
            }
            data.setParameterCallback(this);
            super.ITracer_startTrace(tracerIndex, data);
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        ICpuUsageReporter reporter = MethodCPUTimer.getCPUUsageReporter(this.getAgent());
        if (reporter != null) {
            long endTime;
            long startTime = data.getCPUStartTime();
            if (startTime >= 0L && (endTime = data.getCPUFinishTime()) < 0L) {
                endTime = this.getCPUUsage(reporter);
                data.setCPUFinishTime(endTime);
            }
            super.ITracer_finishTrace(tracerIndex, data);
        }
    }

    @Override
    protected IRepository getRepository(InvocationData data, ISharedMetricHolder metricHolder) {
        RepositoryFactory rf = new RepositoryFactory(this.getAgent().IAgent_getDataAccumulatorFactory(), this.fHighConcurrency);
        IRepository rep = rf.safeGetIntegerAverageDataAccumulator(this.getComponentName(data), metricHolder);
        return rep;
    }

    @Override
    protected void doOnStartTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    @Override
    protected void doOnEndTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
        if (mh == null) {
            return;
        }
        InvocationData invData = (InvocationData)data;
        long cpuStartTime = invData.getCPUStartTime();
        long cpuTime = this.calculateCPUTime(cpuStartTime, invData.getCPUFinishTime());
        int hashCode = invData.hashCode();
        mh.getRepository().update(updater, cpuTime, cpuStartTime, hashCode);
    }

    @Override
    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        parameters.put(CPU_TIME_PARAM_KEY, String.format("%d (ms)", this.calculateCPUTime(data.getCPUStartTime(), data.getCPUFinishTime())));
    }

    private long getCPUUsage(ICpuUsageReporter reporter) {
        try {
            return reporter.ICpuUsageReporter_getCpuUsage();
        }
        catch (InformationNotAvailableException inae) {
            MethodCPUTimer.clearCPUUsageReporter();
            this.getAgent().IAgent_getModuleFeedback().debug("Misconfigured platform monitor threw an exception when attempting to access per thread CPU usage");
            this.getAgent().IAgent_getModuleFeedback().debug(inae);
            return 0L;
        }
    }

    private long calculateCPUTime(long start, long finish) {
        return finish > start ? finish - start : 0L;
    }

    private static ICpuUsageReporter getCPUUsageReporter(IAgent agent) {
        if (!isHopeless && reporter == null) {
            MethodCPUTimer.lookupCPUUsageReporter(agent);
        }
        return reporter;
    }

    private static synchronized void lookupCPUUsageReporter(IAgent agent) {
        if (!isHopeless && reporter == null) {
            try {
                reporter = agent.IAgent_getServiceAdministrator().getCpuUsageReporter();
            }
            catch (InformationNotAvailableException inae) {
                MethodCPUTimer.clearCPUUsageReporter();
                agent.IAgent_getModuleFeedback().error(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Tracer_CPU_Timer_Support_Not_Available_Message"));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                MethodCPUTimer.clearCPUUsageReporter();
                agent.IAgent_getModuleFeedback().error(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_CPU_Timer_Support_Error_Message", t.toString()));
                agent.IAgent_getModuleFeedback().verbose(t);
            }
        }
    }

    private static synchronized void clearCPUUsageReporter() {
        isHopeless = true;
        reporter = null;
    }

    static synchronized void debug_resetCPUUsageReporter() {
        isHopeless = false;
        reporter = null;
    }
}

