/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.v1;

import com.wily.isengard.postofficehub.link.v1.ABaseTransport;
import com.wily.isengard.postofficehub.link.v1.AMessageDeliveryTask;
import com.wily.isengard.postofficehub.link.v1.ARouteConnector;
import com.wily.isengard.postofficehub.link.v1.IsengardObjectOutputStream;
import com.wily.isengard.postofficehub.link.v1.OutgoingMessageDeliveryTask;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.Module;
import com.wily.util.io.IKeyedClassLoader;
import java.io.IOException;
import java.io.ObjectOutput;

class OutgoingRouteConnector
extends ARouteConnector {
    private static Module sModule = new Module("OutgoingRouteConnector");
    private static final long kPingThreshold = 30000L;
    private IKeyedClassLoader fKeyedClassLoader;
    private int fStreamVersion;

    public OutgoingRouteConnector(ABaseTransport transport, int streamVersion, IKeyedClassLoader keyedClassLoader) {
        super(transport);
        this.fKeyedClassLoader = keyedClassLoader;
        this.fStreamVersion = streamVersion;
        if (transport.getOutputStream() == null) {
            throw new IllegalStateException("There is no output stream for sending messages.");
        }
        if (transport.getTransmitChannel() == null) {
            throw new IllegalStateException("There is no channel for retrieving messages to send.");
        }
        if (transport.getSerializationHandler() == null) {
            throw new IllegalStateException("There is no serialization handler.");
        }
    }

    @Override
    protected void doTask() {
        IsengardObjectOutputStream objectOutput = null;
        try {
            try {
                objectOutput = this.getObjectOutputStream(this.fStreamVersion);
                if (objectOutput != null) {
                    this.sendOutgoingMessages(objectOutput);
                }
            }
            catch (Throwable t) {
                this.getFeedbackChannel().error(sModule, "Closing outgoing route connector due to unrecoverable error.", t);
                Thread.interrupted();
                this.getTransport().notifyTransportDown();
                this.closeObjectOutputStream(objectOutput);
            }
        }
        finally {
            Thread.interrupted();
            this.getTransport().notifyTransportDown();
            this.closeObjectOutputStream(objectOutput);
        }
    }

    private IsengardObjectOutputStream getObjectOutputStream(int streamVersion) {
        IsengardObjectOutputStream objectOutput = null;
        boolean errorOccurred = true;
        try {
            try {
                objectOutput = new IsengardObjectOutputStream(this.getTransport().getOutputStream(), streamVersion, this.fKeyedClassLoader, this.getTransport().getSerializationHandler(), this.getFeedbackChannel());
                errorOccurred = false;
            }
            catch (IOException e) {
                if (!this.getTransport().isClosed()) {
                    this.getFeedbackChannel().error(sModule, "Unable to create object output stream.", e);
                }
                this.notifyThreadBlockedOnRouteEstablishment(errorOccurred);
            }
        }
        finally {
            this.notifyThreadBlockedOnRouteEstablishment(errorOccurred);
        }
        return objectOutput;
    }

    private void closeObjectOutputStream(ObjectOutput objectOutput) {
        try {
            if (objectOutput != null) {
                objectOutput.close();
            }
        }
        catch (Exception exception) {}
    }

    private void sendOutgoingMessages(IsengardObjectOutputStream objectOutput) {
        OutgoingMessageDeliveryTask deliveryTask = new OutgoingMessageDeliveryTask(objectOutput, this.getTransport(), false);
        long lastDeliveredTime = MasterClock.currentTimeMillis();
        while (this.isExecuting() && deliveryTask.shouldContinueDelivery()) {
            ((AMessageDeliveryTask)deliveryTask).deliverNextMessage(true);
            int numDelivered = ((AMessageDeliveryTask)deliveryTask).deliverNextMessage(true);
            long currentTime = MasterClock.currentTimeMillis();
            if (numDelivered != 0) {
                lastDeliveredTime = currentTime;
                continue;
            }
            if (currentTime - lastDeliveredTime <= 30000L) continue;
            lastDeliveredTime = currentTime;
            try {
                this.getTransport().pingRemoteHost();
            }
            catch (Exception exception) {}
        }
    }
}

