/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.FixedCompoundClassMatcher;
import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.util.CollectionEquivalenceCheckers;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DGCompoundClassMatcher
implements IClassMatcher {
    private final List fMatchers = new ArrayList();
    private boolean fMatchInProgress = false;
    private boolean fImmutableCreationInProgress = false;

    public void addClassMatcher(IClassMatcher matcher) {
        this.fMatchers.add(matcher);
    }

    public Iterator getClassMatchers() {
        return this.fMatchers.iterator();
    }

    public int size() {
        return this.fMatchers.size();
    }

    private boolean isMatchInProgress() {
        return this.fMatchInProgress;
    }

    private void setMatchInProgress(boolean matchInProgress) {
        this.fMatchInProgress = matchInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        if (!this.isMatchInProgress()) {
            this.setMatchInProgress(true);
            try {
                for (int i = 0; i < this.fMatchers.size(); ++i) {
                    IClassMatcher matcher = (IClassMatcher)this.fMatchers.get(i);
                    if (!matcher.IClassMatcher_matches(cls)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.setMatchInProgress(false);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        if (!this.isMatchInProgress()) {
            this.setMatchInProgress(true);
            try {
                for (int i = 0; i < this.fMatchers.size(); ++i) {
                    IClassMatcher matcher = (IClassMatcher)this.fMatchers.get(i);
                    if (!matcher.IClassMatcher_supportsNameMatching()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.setMatchInProgress(false);
            }
        }
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        if (!this.isMatchInProgress()) {
            this.setMatchInProgress(true);
            try {
                for (int i = 0; i < this.fMatchers.size(); ++i) {
                    IClassMatcher matcher = (IClassMatcher)this.fMatchers.get(i);
                    if (!matcher.IClassMatcher_supportsNameMatching() || !matcher.IClassMatcher_matches(className)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.setMatchInProgress(false);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean IClassMatcher_matches(IModeledClass cls, Map<IClassMatcher, Boolean> resultCache) {
        if (!this.isMatchInProgress()) {
            this.setMatchInProgress(true);
            try {
                for (int i = 0; i < this.fMatchers.size(); ++i) {
                    IClassMatcher matcher = (IClassMatcher)this.fMatchers.get(i);
                    if (!matcher.IClassMatcher_supportsNameMatching() || !matcher.IClassMatcher_matches(cls, resultCache)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.setMatchInProgress(false);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IClassMatcher IClassMatcher_generateImmutableMatcher() {
        if (this.fImmutableCreationInProgress) {
            throw new IllegalStateException("detected a cycle in the class matchers");
        }
        this.fImmutableCreationInProgress = true;
        try {
            if (this.fMatchers.size() == 1) {
                IClassMatcher iClassMatcher = ((IClassMatcher)this.fMatchers.get(0)).IClassMatcher_generateImmutableMatcher();
                return iClassMatcher;
            }
            IClassMatcher[] matchers = new IClassMatcher[this.fMatchers.size()];
            for (int i = 0; i < this.fMatchers.size(); ++i) {
                IClassMatcher matcher = (IClassMatcher)this.fMatchers.get(i);
                matchers[i] = matcher.IClassMatcher_generateImmutableMatcher();
            }
            FixedCompoundClassMatcher fixedCompoundClassMatcher = new FixedCompoundClassMatcher(matchers);
            return fixedCompoundClassMatcher;
        }
        finally {
            this.fImmutableCreationInProgress = false;
        }
    }

    public int hashCode() {
        int result = 17;
        int matcherListResult = 0;
        for (Object o : this.fMatchers) {
            matcherListResult += o.hashCode();
        }
        result = HashCodeUtils.accumulateHashCode((int)result, (int)matcherListResult);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DGCompoundClassMatcher) {
            DGCompoundClassMatcher m = (DGCompoundClassMatcher)obj;
            return CollectionEquivalenceCheckers.listsAreEquivalent((List)this.fMatchers, (List)m.fMatchers);
        }
        return false;
    }

    @Override
    public String[] getMatcherKeys() {
        return kAllKeys;
    }
}

