/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.DGExactClassMatcher;
import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.classmatcher.IDynamicClassMatcher;
import com.wily.introscope.agent.transformer.dynamic.ThreadLocalClassHelper;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import java.util.Map;

public class DGDynamicInheritedClassMatcher
implements IClassMatcher,
IDynamicClassMatcher {
    private final DGExactClassMatcher parentMatcher;

    public DGDynamicInheritedClassMatcher(IClassName seed) {
        this.parentMatcher = DGExactClassMatcher.getInstance(seed);
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        return cls.isInstanceOf(this.parentMatcher.fClassName);
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        try {
            Class actualClass = this.getClass(className);
            if (actualClass != null) {
                Class<?> seedClass = Class.forName(this.parentMatcher.fClassName.getReflectionFriendlyQualifiedNameString(), false, actualClass.getClassLoader());
                if (seedClass != null) {
                    return seedClass.isAssignableFrom(actualClass);
                }
                return false;
            }
            return this.parentMatcher.IClassMatcher_matches(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls, Map<IClassMatcher, Boolean> resultCache) {
        DGDynamicInheritedClassMatcher matcher = this;
        if (!resultCache.containsKey(matcher)) {
            resultCache.put(matcher, this.IClassMatcher_matches(cls));
        }
        return resultCache.get(matcher);
    }

    @Override
    public IClassMatcher IClassMatcher_generateImmutableMatcher() {
        return this.parentMatcher.IClassMatcher_generateImmutableMatcher();
    }

    @Override
    public String[] getMatcherKeys() {
        return this.parentMatcher.getMatcherKeys();
    }

    private Class getClass(IClassName className) {
        return ThreadLocalClassHelper.getClass((IClassName)className);
    }

    @Override
    public IClassName getClassName() {
        return this.parentMatcher.fClassName;
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        return true;
    }
}

