/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.InvalidDirectiveException;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.transform.builder.SubstituteParamByNamedProxyTransformationBuilder;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.ISlotSignature;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;

public final class SubstituteParamByNamedProxyIfFlaggedDirective
extends ADirective {
    private final FlagName fFlagName;
    private final IMethodName fSourceMethod;
    private final String fSubstituter;
    private final int fParamIndex;

    public SubstituteParamByNamedProxyIfFlaggedDirective(String source, int lineNumber, FlagName flagName, IMethodName sourceMethod, int paramIndex, String substituterName) throws InvalidDirectiveException {
        super(source, lineNumber);
        this.validateParameters(sourceMethod, substituterName, paramIndex);
        this.fFlagName = flagName;
        this.fSourceMethod = sourceMethod;
        this.fSubstituter = substituterName;
        this.fParamIndex = paramIndex;
    }

    private void validateParameters(IMethodName sourceMethod, String substituterName, int paramIndex) throws InvalidDirectiveException {
        IMethodSignature sourceDescriptor = sourceMethod.getSignature();
        int paramCount = sourceDescriptor.getParameterCount();
        if (paramIndex >= paramCount) {
            throw new InvalidDirectiveException("Substitute parameter index is out of range.", (ILocalizableMessage)new SimpleLocalizableMessage("Substitute parameter index is out of range."));
        }
        ISlotSignature paramSignature = sourceDescriptor.getParameterSignatureByIndex(paramIndex);
        if (!paramSignature.isAnyReference()) {
            throw new InvalidDirectiveException("Substitute parameter must be a reference.", (ILocalizableMessage)new SimpleLocalizableMessage("Substitute parameter must be a reference."));
        }
    }

    private FlagName getFlagName() {
        return this.fFlagName;
    }

    private IMethodName getSourceMethod() {
        return this.fSourceMethod;
    }

    private String getSubstituterName() {
        return this.fSubstituter;
    }

    private int getParamIndex() {
        return this.fParamIndex;
    }

    @Override
    protected void applyToSettings(CompilerSettingsBuilder builder) {
        TracerGroupBuilder tracerGroupBuilder = builder.getTracerGroupBuilder(this.getFlagName());
        builder.addTransformation(new SubstituteParamByNamedProxyTransformationBuilder(tracerGroupBuilder, this.getSourceMethod(), this.getParamIndex(), this.getSubstituterName()));
        tracerGroupBuilder.setSource(this.getSource());
    }
}

