/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.transform.AClassTransformation;
import com.wily.diagnos.cmp.transform.ITracerGroupTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.SubscribeToClassTransformationBuilder;
import com.wily.util.classfile.IModeledClass;

public class SubscribeToClassTransformation
extends AClassTransformation
implements ITracerGroupTransformation {
    private final TracerGroup fTracerGroup;
    private final String fSubscriberPluginName;

    public SubscribeToClassTransformation(ICompilerLog log, TracerGroup tracerGroup, String subscriberPluginName) {
        super(log);
        this.fTracerGroup = tracerGroup;
        this.fSubscriberPluginName = subscriberPluginName;
    }

    @Override
    public TracerGroup getTracerGroup() {
        return this.fTracerGroup;
    }

    public String getSubscriberPluginName() {
        return this.fSubscriberPluginName;
    }

    @Override
    protected boolean doShouldProcessClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return !ClassSettingsApplier.shouldSkipClassForTracerGroup(this.getLog(), targetClass, this.getTracerGroup());
    }

    @Override
    protected boolean doShouldMutateClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return this.getTracerGroup().getClassMatcher().IClassMatcher_matches(targetClass);
    }

    @Override
    protected IMutation doGenerateClassMutation(DGCompilerSettings settings, IClassMutator mutator, IModeledClass targetClass) {
        return mutator.newSubscribeToClassMutation(settings, targetClass, this.getSubscriberPluginName());
    }

    @Override
    public ITransformationBuilder generateTransformationBuilder(CompilerSettingsBuilder builder) {
        return new SubscribeToClassTransformationBuilder(builder.getTracerGroupBuilder(this.getTracerGroup()), this.getSubscriberPluginName());
    }
}

