/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.mutate;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.cmp.transform.SubstituteClassTransformation;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.diagnos.personality.java.mutate.AJavaClassMutation;
import com.wily.util.classfile.ClassFileException;
import com.wily.util.classfile.IModeledClass;
import com.wily.wilyassert.Assertion;
import java.io.IOException;

public final class SubstituteSuperclassClassMutation
extends AJavaClassMutation {
    private final SubstituteClassTransformation fTransform;

    public SubstituteSuperclassClassMutation(DGCompilerSettings settings, IClassMutator mutator, SubstituteClassTransformation transform, IModeledClass targetClass) {
        super(settings, mutator, targetClass);
        this.fTransform = transform;
    }

    @Override
    protected void doMutate(DGClass targetClass) throws DGClassModificationException, IOException {
        String className = this.fTransform.getSourceClass().getPackageAndNameString();
        String subclassName = this.fTransform.getReplacementClass().getPackageAndNameString();
        DGConstantPool cp = targetClass.getConstantPool();
        int cpiClass = cp.findClassReference(className);
        Assertion.wilyAssert((cpiClass != 0 ? 1 : 0) != 0);
        Assertion.wilyAssert((!className.equals(targetClass.getClassName().getPackageAndNameString()) ? 1 : 0) != 0);
        int cpiSubstituteClass = cp.addClassReferenceIfNecessary(subclassName);
        try {
            if (className.equals(targetClass.getSuperClassQualifiedNameString())) {
                targetClass.setSuperClassCPI(cpiSubstituteClass);
                targetClass.getLog().ICompilerLog_logInheritanceChange(this.fTransform.getSourceClass(), this.fTransform.getReplacementClass());
            }
        }
        catch (ClassFileException cfe) {
            throw new DGClassModificationException();
        }
    }
}

