/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub;

import com.wily.isengard.postoffice.PostOfficeHub;
import com.wily.isengard.postoffice.PostOfficeSpecifier;
import com.wily.isengard.postofficehub.Route;
import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.HashMap;
import java.util.Map;

public class RoutingTable {
    private static final Module sModule = new Module("RoutingTable");
    private static final Route[] kNoRoutes = new Route[0];
    private final Map fTable;
    private final PostOfficeHub fHub;
    private final IModuleFeedbackChannel fFeedback;

    public RoutingTable(PostOfficeHub hub) {
        CheckParameter.notNull("Post Office Hub", hub);
        this.fHub = hub;
        this.fTable = new HashMap();
        this.fFeedback = hub.getFeedbackChannel();
    }

    public void add(Route route) {
        this.fTable.put(route.getPostOffice(), route);
        this.printTable();
    }

    public Route[] getRoutes() {
        return this.fTable.values().toArray(kNoRoutes);
    }

    public boolean addIfNotExists(Route route) {
        boolean added = false;
        if (!this.fTable.containsKey(route.getPostOffice())) {
            this.add(route);
            added = true;
        }
        return added;
    }

    public Route getRoute(PostOfficeSpecifier postOffice) {
        return (Route)this.fTable.get(postOffice);
    }

    public void remove(Route route) {
        this.fTable.remove(route.getPostOffice());
        this.printTable();
    }

    private void printTable() {
        if (this.getFeedbackChannel().isTraceEnabled(sModule)) {
            this.getFeedbackChannel().trace(sModule, "Routing Table for: " + this.fHub.getHubName());
            Route[] routes = this.getRoutes();
            int i = 0;
            int j = 1;
            int n = routes.length;
            while (i < n) {
                this.getFeedbackChannel().trace(sModule, " [" + j + "] " + routes[i]);
                ++i;
                ++j;
            }
        }
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }
}

