/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import java.util.List;
import java.util.Map;

public interface IUMAAgentControllerService {
    public int sendUMAAutoAttachApplication(AutoAttachApplicationData var1);

    public int sendUMAConfiguration(Map<ConfigTypeWithUUID, Map<String, String>> var1);

    public void addUMAControllerConnectionListener(IUMAAgentControllerConnectionListener var1);

    public void removeUMAControllerConnectionListener(IUMAAgentControllerConnectionListener var1);

    public static interface IUMAAgentControllerConnectionListener {
        public void umaAgentControllerConnected();

        public void umaAgentControllerDisconnected();
    }

    public static enum Action {
        ADDED,
        UPDATED,
        DELETED,
        RECONCILE;

    }

    public static enum AgentConfigurationType {
        ANNOTATED,
        ACC_ANNOTATED;

    }

    public static enum DiscoveryType {
        WHITELIST,
        BLACKLIST;

    }

    public static enum WorkloadType {
        DAEMONSET,
        DEPLOYMENT,
        DEPLOYMENTCONFIG,
        STATEFULSET;

    }

    public static enum AttachType {
        DYNAMIC,
        SIDECAR;

    }

    public static enum AppAgentTechnology {
        JAVA,
        DOTNET,
        NGINX,
        PHP,
        NODEJS,
        PYTHON,
        UNKNOWN;

    }

    public static enum AutoAttachStatus {
        ATTACH_SUCCESSFUL,
        ATTACH_FAILED,
        ATTACH_SKIPPED,
        INSUFFICIENT_APPLICATION_POD_MEMORY,
        UNSUPPORTED_VERSION,
        TOOLS_JAR_MISSING,
        INSUFFICIENT_PERMISSIONS,
        DISCOVERED,
        UNKNOWN;

    }

    public static enum ConfigurationType {
        UMA_CORE,
        UMA_PROMETHEUS,
        UMA_KAFKA;

    }

    public static final class ConfigTypeWithUUID {
        ConfigurationType configurationType;
        String uuid;

        public ConfigTypeWithUUID(ConfigurationType configurationType, String uuid) {
            this.configurationType = configurationType;
            this.uuid = uuid;
        }

        public ConfigurationType getConfigurationType() {
            return this.configurationType;
        }

        public String getUuid() {
            return this.uuid;
        }
    }

    public static final class AnnotatedAgentConfiguration {
        public final AgentConfigurationType type;
        public Map<String, String> configuration;

        public AnnotatedAgentConfiguration(AgentConfigurationType type, Map<String, String> configuration) {
            this.type = type;
            this.configuration = configuration;
        }

        public Map<String, String> getConfiguration() {
            return this.configuration;
        }
    }

    public static final class Application {
        public final String containerId;
        public final String podName;
        public final String namespaceName;
        public final String ownerName;
        public final WorkloadType owner;
        public AppAgentTechnology appTechnology;
        public AttachType autoAttachType;
        public String agentVersion;
        public AnnotatedAgentConfiguration configuration;
        public AutoAttachStatus status;
        public String detailedMessage;

        public Application(String containerId, String podName, String namespaceName, String ownerName, WorkloadType owner, AppAgentTechnology appTechnology, AttachType autoAttachType, String agentVersion, AnnotatedAgentConfiguration configuration, AutoAttachStatus status, String detailedMessage) {
            this.containerId = containerId;
            this.podName = podName;
            this.namespaceName = namespaceName;
            this.ownerName = ownerName;
            this.owner = owner;
            this.appTechnology = appTechnology;
            this.autoAttachType = autoAttachType;
            this.agentVersion = agentVersion;
            this.configuration = configuration;
            this.status = status;
            this.detailedMessage = detailedMessage;
        }

        public void setAppTechnology(AppAgentTechnology technology) {
            this.appTechnology = technology;
        }

        public void setAutoAttachType(AttachType type) {
            this.autoAttachType = type;
        }

        public void setAgentVersion(String version) {
            this.agentVersion = version;
        }

        public void setStatus(AutoAttachStatus status) {
            this.status = status;
        }

        public void setDetailedMessage(String message) {
            this.detailedMessage = message;
        }

        public void setConfiguration(AnnotatedAgentConfiguration conf) {
            this.configuration = conf;
        }

        public AutoAttachStatus getStatus() {
            return this.status;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public AnnotatedAgentConfiguration getConfiguration() {
            return this.configuration;
        }
    }

    public static final class AutoAttachApplicationData {
        public final List<Application> app;
        public final DiscoveryType type;
        public final Action action;

        public AutoAttachApplicationData(List<Application> app, DiscoveryType type, Action action) {
            this.app = app;
            this.type = type;
            this.action = action;
        }
    }
}

