/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.recording;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.poll.IMetricRecordingAwareDataPoller;
import com.wily.introscope.agent.recording.IMetricRecordingListener;
import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.wilyassert.Assertion;

public final class MetricRecordingPollerHandler
implements IMetricRecordingListener {
    private final IAgent fAgent;
    private final IMetricRecordingAwareDataPoller fPoller;
    private final AgentMetric[] fMetrics;
    private final boolean[] fIsRecording;
    private int fRecordingCount;
    private IRegisteredBehavior fBehavior;
    private boolean fTornDown;
    private static final long kInitialPollingDelay = 1000L;

    MetricRecordingPollerHandler(IAgent agent, IMetricRecordingAwareDataPoller poller, long initialPollingDelay) {
        this.fAgent = agent;
        this.fPoller = poller;
        this.fMetrics = this.fPoller.IMetricRecordingAwareDataPoller_getMetrics();
        this.fIsRecording = new boolean[this.fMetrics.length];
        this.fRecordingCount = 0;
        this.fTornDown = false;
        this.fBehavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this.fPoller, "Data Poller", false, 2500L, System.currentTimeMillis() + initialPollingDelay);
        this.addRecordingListeners();
    }

    public MetricRecordingPollerHandler(IAgent agent, IMetricRecordingAwareDataPoller poller) {
        this(agent, poller, 1000L);
    }

    public void teardown() {
        this.removeRecordingListeners();
        this.tearDownPoller();
    }

    private void addRecordingListeners() {
        MetricRecordingAdministrator administrator = this.fAgent.IAgent_getMetricRecordingAdministrator();
        for (int i = 0; i < this.fMetrics.length; ++i) {
            administrator.addMetricRecordingListenerWithRewind(this.fMetrics[i], this);
        }
    }

    private void removeRecordingListeners() {
        MetricRecordingAdministrator administrator = this.fAgent.IAgent_getMetricRecordingAdministrator();
        for (int i = 0; i < this.fMetrics.length; ++i) {
            administrator.removeMetricRecordingListener(this.fMetrics[i], this);
        }
    }

    private int getMetricIndex(AgentMetric metric) {
        for (int i = 0; i < this.fMetrics.length; ++i) {
            if (metric != this.fMetrics[i]) continue;
            return i;
        }
        Assertion.wilyAssert(false);
        return -1;
    }

    @Override
    public void IMetricRecordingListener_metricIsShutOff(AgentMetric metric) {
        int index = this.getMetricIndex(metric);
        if (index >= 0 && this.fIsRecording[index]) {
            this.fIsRecording[index] = false;
            if (--this.fRecordingCount == 0) {
                this.disableDataPoller();
            }
        }
    }

    @Override
    public void IMetricRecordingListener_metricIsTurnedOn(AgentMetric metric) {
        int index = this.getMetricIndex(metric);
        if (index >= 0 && !this.fIsRecording[index]) {
            this.fIsRecording[index] = true;
            if (++this.fRecordingCount == 1) {
                this.enableDataPoller();
            }
        }
    }

    private synchronized void enableDataPoller() {
        if (!this.fTornDown) {
            this.fPoller.IMetricRecordingAwareDataPoller_resetPoller();
            this.fBehavior.IRegisteredBehavior_setEnableState(true);
        }
    }

    private synchronized void disableDataPoller() {
        if (!this.fTornDown) {
            this.fBehavior.IRegisteredBehavior_setEnableState(false);
        }
    }

    private synchronized void tearDownPoller() {
        this.fTornDown = true;
        boolean result = this.fAgent.IAgent_getCommonHeartbeat().removeBehavior(this.fBehavior);
        Assertion.wilyAssert(false);
    }
}

