/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.ejb;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.ejb.AEjbNameFormatter;
import com.wily.introscope.agent.trace.ejb.EJBHomeWrapper;
import com.wily.introscope.agent.trace.ejb.EJBMetaDataWrapper;
import com.wily.introscope.agent.trace.ejb.EjbObjectFactory;
import com.wily.introscope.agent.trace.ejb.EntityContextWrapper;
import com.wily.introscope.agent.trace.ejb.MessageDrivenContextWrapper;
import com.wily.introscope.agent.trace.ejb.SessionContextWrapper;
import com.wily.util.classfile.NameUtilities;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import com.wily.util.text.IStringLocalizer;
import java.lang.reflect.InvocationTargetException;

public final class EjbContextTracer
extends ASingleInstanceTracerFactory {
    private static final String kLocalInterfaceName = "LocalInterface";
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;

    public EjbContextTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fLocalizer = agent.IAgent_getStringLocalizer();
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String interfaceName = null;
        Object contextObj = data.getInvocationParameterAsObject(0);
        if (contextObj == null) {
            return;
        }
        Class<?> clazz = contextObj.getClass();
        interfaceName = this.findInterfaceName(clazz, contextObj);
        if (interfaceName == null) {
            this.fFeedback.error("Could not find EJB interface from context.");
            return;
        }
        AEjbNameFormatter.setInterfaceToCache(data, interfaceName);
    }

    private String findInterfaceName(Class clazz, Object contextObj) {
        if (clazz == null) {
            return null;
        }
        String interfaceName = null;
        try {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i].getName().equals("javax.ejb.SessionContext")) {
                    SessionContextWrapper sessionContext = EjbObjectFactory.getEjbObjectFactory(contextObj).getSessionContextWrapper(contextObj);
                    EJBHomeWrapper ejbHome = sessionContext.getEJBHome();
                    if (ejbHome != null) {
                        EJBMetaDataWrapper ejbMetaData = ejbHome.getEJBMetaData();
                        if (ejbMetaData != null) {
                            Class ejbInterface = ejbMetaData.getRemoteInterfaceClass();
                            interfaceName = NameUtilities.parseSimpleClassName(ejbInterface.getName());
                        }
                    } else {
                        interfaceName = kLocalInterfaceName;
                    }
                } else if (interfaces[i].getName().equals("javax.ejb.EntityContext")) {
                    EntityContextWrapper entityContext = EjbObjectFactory.getEjbObjectFactory(contextObj).getEntityContextWrapper(contextObj);
                    EJBHomeWrapper ejbHome = entityContext.getEJBHome();
                    if (ejbHome != null) {
                        EJBMetaDataWrapper ejbMetaData = ejbHome.getEJBMetaData();
                        if (ejbMetaData != null) {
                            Class ejbInterface = ejbMetaData.getRemoteInterfaceClass();
                            interfaceName = NameUtilities.parseSimpleClassName(ejbInterface.getName());
                        }
                    } else {
                        interfaceName = kLocalInterfaceName;
                    }
                } else if (interfaces[i].getName().equals("javax.ejb.MessageDrivenContext")) {
                    EJBMetaDataWrapper ejbMetaData;
                    MessageDrivenContextWrapper messageDrivenContext = EjbObjectFactory.getEjbObjectFactory(contextObj).getMessageDrivenContextWrapper(contextObj);
                    EJBHomeWrapper ejbHome = messageDrivenContext.getEJBHome();
                    if (ejbHome != null && (ejbMetaData = ejbHome.getEJBMetaData()) != null) {
                        Class ejbInterface = ejbMetaData.getRemoteInterfaceClass();
                        interfaceName = NameUtilities.parseSimpleClassName(ejbInterface.getName());
                    }
                } else {
                    interfaceName = this.findInterfaceName(interfaces[i], contextObj);
                    if (interfaceName == null) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (ClassNotFoundException e) {
            this.fFeedback.error("An error occurred retrieving EJB interface.");
            this.fFeedback.verbose(e);
        }
        catch (SecurityException e) {
            this.fFeedback.error("An error occurred retrieving EJB interface.");
            this.fFeedback.verbose(e);
        }
        catch (IllegalArgumentException e) {
            this.fFeedback.error("An error occurred retrieving EJB interface.");
            this.fFeedback.verbose(e);
        }
        catch (NoSuchMethodException e) {
            this.fFeedback.error("An error occurred retrieving EJB interface.");
            this.fFeedback.verbose(e);
        }
        catch (IllegalAccessException e) {
            this.fFeedback.error("An error occurred retrieving EJB interface.");
            this.fFeedback.verbose(e);
        }
        catch (InvocationTargetException e) {
            this.fFeedback.error("An error occurred retrieving EJB interface.");
            this.fFeedback.verbose(e);
        }
        if (interfaceName == null) {
            interfaceName = this.findInterfaceName(clazz.getSuperclass(), contextObj);
        }
        return interfaceName;
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }
}

