/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io.clamp;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.clamp.ASocketClampManager;
import com.wily.introscope.agent.trace.io.clamp.TracedSockets;
import com.wily.util.properties.AttributeListing;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;

public class ServerSocketChannelInitClampManager
extends ASocketClampManager {
    public ServerSocketChannelInitClampManager(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected void decideOnClamp(InvocationData data) {
        boolean traced = false;
        try {
            ServerSocketChannel serverChannel = (ServerSocketChannel)data.getInvocationObject();
            ServerSocket srvSocket = serverChannel.socket();
            traced = TracedSockets.isTraced(srvSocket.getLocalPort());
            if (!traced) {
                traced = TracedSockets.add(srvSocket.getLocalPort());
            }
            if (!traced) {
                data.setSocketClamp(!traced);
            }
        }
        catch (UnsupportedOperationException e) {
            this.getModuleFeedback().debug("Cannot get socket for SocketChannel, it's probably UnixDomainSocket.");
            data.setSocketClamp(true);
        }
        catch (Exception e) {
            this.getModuleFeedback().error(e);
        }
    }
}

