/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.sap;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Method;

public class WebDynproApplicationNameFormatter
implements INameFormatter {
    private static final String WD_NF_WILY = "{wd_nf_wily}";
    private static final String WD_NF_WILY_SHORT = "{wd_nf_wily_short}";
    private static final String WD_NF_WILY_LONG = "{wd_nf_wily_long}";
    private static final String WD_NF_WILY_OBJNAME = "{wd_nf_wily_objname}";
    private static final String M_getApplicationDeployableObjecPart = "getApplicationDeployableObjecPart";
    private static final String M_getShortName = "getShortName";
    private static final String M_getLongName = "getLongName";
    private static final String M_getDeployableObjectName = "getDeployableObjectName";
    private final IModuleFeedbackChannel fLogOutput;

    public WebDynproApplicationNameFormatter(IAgent agent) {
        this.fLogOutput = agent.IAgent_getModuleFeedback();
    }

    @Override
    public String INameFormatter_format(String stOriginal, InvocationData invocationData) {
        String stFormattedName;
        block10: {
            if (this.fLogOutput.isDebugEnabled()) {
                this.fLogOutput.debug("[WebDynproNameFormatter] INameFormatter_format invoked with metric name: " + stOriginal);
            }
            if (stOriginal.indexOf(WD_NF_WILY) < 0) {
                return stOriginal;
            }
            stFormattedName = null;
            try {
                if (invocationData.getInvocationParameterCount() == 0) {
                    if (this.fLogOutput.isDebugEnabled()) {
                        this.fLogOutput.debug("[WebDynproNameFormatter] InvocationData has no params");
                    }
                    return stOriginal;
                }
                Object o = invocationData.getInvocationParameterAsObject(0);
                Method m = o.getClass().getMethod(M_getApplicationDeployableObjecPart, null);
                o = m.invoke(o, null);
                if (stOriginal.indexOf(WD_NF_WILY_SHORT) > -1) {
                    m = o.getClass().getMethod(M_getShortName, null);
                    String shortName = (String)m.invoke(o, null);
                    stFormattedName = StringUtils.replace(stOriginal, WD_NF_WILY_SHORT, shortName);
                    break block10;
                }
                if (stOriginal.indexOf(WD_NF_WILY_LONG) > -1) {
                    m = o.getClass().getMethod(M_getLongName, null);
                    String longName = (String)m.invoke(o, null);
                    stFormattedName = StringUtils.replace(stOriginal, WD_NF_WILY_LONG, longName);
                    break block10;
                }
                if (stOriginal.indexOf(WD_NF_WILY_OBJNAME) > -1) {
                    m = o.getClass().getMethod(M_getDeployableObjectName, null);
                    String objectName = (String)m.invoke(o, null);
                    stFormattedName = StringUtils.replace(stOriginal, WD_NF_WILY_OBJNAME, objectName);
                    break block10;
                }
                return stOriginal;
            }
            catch (Throwable t) {
                this.fLogOutput.debug("[WebDynproNameFormatter] Error formatting Web Dynpro Application Name: " + t.toString());
                return stOriginal;
            }
        }
        if (this.fLogOutput.isDebugEnabled()) {
            this.fLogOutput.debug("[WebDynproNameFormatter] Modified metric name: " + stOriginal + ", new metric name is: " + stFormattedName);
        }
        return stFormattedName;
    }
}

