/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transformer.dynamic;

import com.wily.introscope.agent.transformer.dynamic.IOverheadHandler;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.util.properties.IndexedProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OverheadSettings {
    public static final int ABSOLUTE_LOW_MODE = 0;
    public static final int LOW_WITH_ONLY_FRONTEND_BACKEND = 1;
    public static final int DEFAULT_MODE = 2;
    private Set forcedOnFeatures = new HashSet();
    private Set forcedOffFeatures = new HashSet();
    private IOverheadHandler overheadHandler = null;
    private static Map<OverheadMode, IOverheadHandler> overheadHandlers = new HashMap<OverheadMode, IOverheadHandler>();
    private static Map INITIAL_DEFAULT_SETTINGS;
    private static IndexedProperties INITIAL_AGENT_PROPERTIES;
    public static final Set UNCHANGEABLE_FLAGS;
    public static final List<String> HTTP_BACKEND_TRACER_GROUPS;
    public static final Map<String, String> ABSOLUTE_LOW_MODE_PROPERTIES;
    public static final Map<String, String> LOW_MODE_WITH_ONLY_FRONTEND_BACKEND_PROPERTIES;
    public static final Map<String, String> DEFAULT_MODE_PROPERTIES;

    private OverheadSettings(String[] forcedOn, String[] forcedOff, IOverheadHandler overheadHandler) {
        this.forcedOnFeatures.addAll(Arrays.asList(forcedOn));
        this.forcedOffFeatures.addAll(Arrays.asList(forcedOff));
        this.overheadHandler = overheadHandler;
    }

    public void addToForceOnList(String feature) {
        this.forcedOnFeatures.add(feature);
    }

    public void removeFromForceOnList(String feature) {
        this.forcedOnFeatures.remove(feature);
    }

    public void addToForceOffList(String feature) {
        this.forcedOffFeatures.add(feature);
    }

    public void removeFromForceOffList(String feature) {
        this.forcedOffFeatures.remove(feature);
    }

    public static OverheadSettings of(int mode) {
        ArrayList<String> forceOn = new ArrayList<String>();
        forceOn.add("SpringBootApplicationNaming");
        if (1 == mode) {
            forceOn.add("HTTPServletTracing");
            forceOn.add("ServletFilterTracing");
            forceOn.addAll(HTTP_BACKEND_TRACER_GROUPS);
        }
        return new OverheadSettings(forceOn.toArray(new String[0]), new String[0], overheadHandlers.get(mode));
    }

    public Set getForceOnList() {
        return this.forcedOnFeatures;
    }

    public static boolean isUnchangeable(String flagName) {
        return UNCHANGEABLE_FLAGS.contains(flagName);
    }

    public static void registerOverheadHandler(OverheadMode overheadMode, IOverheadHandler overheadHandler) {
        overheadHandlers.put(overheadMode, overheadHandler);
    }

    public static IOverheadHandler getOverheadHandler(OverheadMode overheadMode) {
        return overheadHandlers.get((Object)overheadMode);
    }

    public static IOverheadHandler getOverheadHandler(String overheadMode) {
        if ("Normal".equalsIgnoreCase(overheadMode)) {
            return overheadHandlers.get((Object)OverheadMode.DEFAULT);
        }
        if ("None".equalsIgnoreCase(overheadMode)) {
            return overheadHandlers.get((Object)OverheadMode.ABSOLUTE_LOW);
        }
        if ("Low".equalsIgnoreCase(overheadMode)) {
            return overheadHandlers.get((Object)OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND);
        }
        return overheadHandlers.get((Object)OverheadMode.DEFAULT);
    }

    public static Map getInitialTracerGroupSettings() {
        return INITIAL_DEFAULT_SETTINGS;
    }

    public static void setInitialTracerGroupSettings(Map settings) {
        INITIAL_DEFAULT_SETTINGS = settings;
    }

    public static void setInitialAgentProperties(IndexedProperties properties) {
        INITIAL_AGENT_PROPERTIES = properties;
    }

    public static IndexedProperties getInitialAgentProperties() {
        return INITIAL_AGENT_PROPERTIES;
    }

    static {
        UNCHANGEABLE_FLAGS = new HashSet<String>(Arrays.asList("SocketTracing", "FileSystemTracing", "UDPTracing", "NIOSocketSummaryTracing", "NIOSelectorTracing", "NIOSocketTracing", "NIODatagramTracing", "NIODatagramSummaryTracing", "ThreadTracing", "AsyncFieldInjectionEnabled"));
        HTTP_BACKEND_TRACER_GROUPS = Arrays.asList("HTTPBackend", "ApacheHTTPClientBackendTracing", "HttpURLConnectionBackendTracing", "SpringHTTPClientBackend");
        ABSOLUTE_LOW_MODE_PROPERTIES = new HashMap<String, String>();
        LOW_MODE_WITH_ONLY_FRONTEND_BACKEND_PROPERTIES = new HashMap<String, String>();
        DEFAULT_MODE_PROPERTIES = new HashMap<String, String>();
    }
}

