/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.container;

import com.wily.isengard.container.beans.AIsengardBean;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.stream.IMessageStream;
import com.wily.isengard.messageprimitives.stream.MessageStreamSubscriber;
import com.wily.isengard.messageprimitives.stream.StreamSpecifier;
import com.wily.isengard.ongoingquery.QuerySyntaxException;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.registry.RegistryEntry;
import com.wily.isengard.service.subscription.stream.AStreamSubscription;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.HashMap;
import java.util.Map;

class DynamicBeanSubscription {
    private static Module sModule = new Module("BeanStreamSubscription");
    private final IMessageStream fCallHandler;
    private final AIsengardBean fBean;
    private final Map<StreamSpecifier, MessageStreamSubscriber> fSubscriptions;
    private final PostOffice fPostOffice;
    private final BeanStreamSubscription fStreamSubscription;
    private final IModuleFeedbackChannel fFeedback;

    DynamicBeanSubscription(PostOffice po, IMessageStream handler, AIsengardBean bean, String query) throws QuerySyntaxException, ConnectionException {
        this.fCallHandler = handler;
        this.fPostOffice = po;
        this.fBean = bean;
        this.fSubscriptions = new HashMap<StreamSpecifier, MessageStreamSubscriber>();
        this.fFeedback = po.getFeedbackChannel();
        this.fStreamSubscription = new BeanStreamSubscription(po, query);
        this.fStreamSubscription.subscribe();
    }

    void close() {
        this.fStreamSubscription.close();
        for (MessageStreamSubscriber sub : this.fSubscriptions.values()) {
            sub.close();
        }
        this.fSubscriptions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribeTo(StreamSpecifier stream, IMessageStream callHandler) {
        Map<StreamSpecifier, MessageStreamSubscriber> map = this.fSubscriptions;
        synchronized (map) {
            if (!this.fSubscriptions.containsKey(stream)) {
                try {
                    MessageStreamSubscriber sub = new MessageStreamSubscriber(this.fPostOffice);
                    sub.subscribeTo(stream.getStreamAddress(), callHandler);
                    this.fSubscriptions.put(stream, sub);
                }
                catch (ConnectionException connectionException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribeFrom(StreamSpecifier stream, IMessageStream callHandler) {
        Map<StreamSpecifier, MessageStreamSubscriber> map = this.fSubscriptions;
        synchronized (map) {
            MessageStreamSubscriber sub = this.fSubscriptions.remove(stream);
            if (sub != null) {
                sub.close();
            }
        }
    }

    private class BeanStreamSubscription
    extends AStreamSubscription {
        public BeanStreamSubscription(PostOffice po, String matchingPattern) {
            super(po, matchingPattern);
        }

        public void subscribe() throws QuerySyntaxException, ConnectionException {
            this.activateSubscription();
        }

        @Override
        protected void newStreamAvailable(StreamSpecifier stream, RegistryEntry properties) {
            if (this.getFeedbackChannel().isTraceEnabled()) {
                this.getFeedbackChannel().trace(sModule, "DynamicBeanSubscription available:" + stream.getStreamName() + " for bean " + DynamicBeanSubscription.this.fBean.toString());
            }
            DynamicBeanSubscription.this.subscribeTo(stream, DynamicBeanSubscription.this.fCallHandler);
        }

        @Override
        protected void streamWentAway(StreamSpecifier stream, RegistryEntry properties) {
            if (this.getFeedbackChannel().isTraceEnabled()) {
                this.getFeedbackChannel().trace(sModule, "DynamicBeanSubscription available:" + stream.getStreamName() + " for bean " + DynamicBeanSubscription.this.fBean.toString());
            }
            DynamicBeanSubscription.this.unsubscribeFrom(stream, DynamicBeanSubscription.this.fCallHandler);
        }
    }
}

