/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.v1;

import com.wily.isengard.postofficehub.link.v1.ABaseTransport;
import com.wily.isengard.postofficehub.link.v1.AMessageDeliveryTask;
import com.wily.isengard.postofficehub.link.v1.ARouteConnector;
import com.wily.isengard.postofficehub.link.v1.IncomingMessageDeliveryTask;
import com.wily.isengard.postofficehub.link.v1.IsengardObjectInputStream;
import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.feedback.Module;
import com.wily.util.io.IKeyedClassLoader;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.concurrent.CountDownLatch;

public class IncomingRouteConnector
extends ARouteConnector {
    private static Module sModule = new Module("IncomingRouteConnector");
    private IKeyedClassLoader fKeyedClassLoader;
    private CountDownLatch fVersionLatch;
    private int fInputStreamVersion;

    public IncomingRouteConnector(ABaseTransport transport, IKeyedClassLoader keyedClassLoader) {
        super(transport);
        this.fKeyedClassLoader = keyedClassLoader;
        this.fVersionLatch = new CountDownLatch(1);
        if (transport.getInputStream() == null) {
            throw new IllegalStateException("There is no input stream for receiving messages.");
        }
        if (transport.getSerializationHandler() == null) {
            throw new IllegalStateException("There is no serialization handler.");
        }
    }

    public int getInputStreamVersion() {
        try {
            this.fVersionLatch.await();
        }
        catch (InterruptedException e) {
            throw new UnexpectedExceptionError(e);
        }
        return this.fInputStreamVersion;
    }

    @Override
    protected void doTask() {
        IsengardObjectInputStream objectInput = null;
        try {
            try {
                objectInput = this.getObjectInputStream(this.fKeyedClassLoader);
                this.fInputStreamVersion = objectInput.getStreamVersion();
                this.fVersionLatch.countDown();
                if (objectInput != null) {
                    this.receiveIncomingMessages(objectInput);
                }
            }
            catch (Throwable t) {
                this.fVersionLatch.countDown();
                this.getFeedbackChannel().error(sModule, "Closing incoming route connector due to unrecoverable error.", t);
                Thread.interrupted();
                this.getTransport().notifyTransportDown();
                this.closeObjectInputStream(objectInput);
            }
        }
        finally {
            Thread.interrupted();
            this.getTransport().notifyTransportDown();
            this.closeObjectInputStream(objectInput);
        }
    }

    private IsengardObjectInputStream getObjectInputStream(IKeyedClassLoader keyedClassLoader) throws IOException {
        IsengardObjectInputStream objectInput = null;
        boolean errorOccurred = true;
        try {
            try {
                objectInput = new IsengardObjectInputStream(keyedClassLoader, this.getTransport().getInputStream(), this.getTransport().getSerializationHandler(), this.getFeedbackChannel());
                errorOccurred = false;
            }
            catch (IOException e) {
                if (!this.getTransport().isClosed()) {
                    this.getFeedbackChannel().debug(sModule, "Unable to create object input stream.", e);
                }
                throw e;
            }
        }
        finally {
            this.notifyThreadBlockedOnRouteEstablishment(errorOccurred);
        }
        return objectInput;
    }

    private void closeObjectInputStream(ObjectInput objectInput) {
        try {
            if (objectInput != null) {
                objectInput.close();
            }
        }
        catch (Exception exception) {}
    }

    private void receiveIncomingMessages(IsengardObjectInputStream objectInput) {
        IncomingMessageDeliveryTask deliveryTask = new IncomingMessageDeliveryTask(objectInput, this.getTransport());
        while (this.isExecuting() && deliveryTask.shouldContinueDelivery()) {
            ((AMessageDeliveryTask)deliveryTask).deliverNextMessage(true);
        }
    }
}

