/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlparamagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlparamagent.SimplifiedSingleInstanceTracerFactoryHC;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.properties.AttributeListing;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Map;

public final class PrepStmtSetTracer
extends SimplifiedSingleInstanceTracerFactoryHC {
    public static final String kSqlBindParamKey = "SQL Bind Param";
    private static final String[] kBindParamKeyArray = new String[]{"SQL Bind Param0", "SQL Bind Param1", "SQL Bind Param2", "SQL Bind Param3", "SQL Bind Param4", "SQL Bind Param5", "SQL Bind Param6", "SQL Bind Param7", "SQL Bind Param8", "SQL Bind Param9"};
    private final String fBindParamValue;
    private final boolean isShutOff;
    private static final String kSetNullMethod = "setNull";
    private static final String kSetNullValue = "NULL";
    private static final String kSetAsciiStreamMethod = "setAsciiStream";
    private static final String kSetAsciiStreamValue = "ASCII_STREAM";
    private static final String kSetBinaryStreamMethod = "setBinaryStream";
    private static final String kSetBinaryStreamValue = "BINARY_STREAM";
    private static final String kSetClobMethod = "setClob";
    private static final String kSetClobValue = "CLOB";
    private static final String kSetBlobMethod = "setBlob";
    private static final String kSetBlobValue = "BLOB";
    private static final String kSetCharacterSteamMethod = "setCharacterStream";
    private static final String kSetCharacterSteamValue = "CHARACTER_STREAM";
    private static final String kSetArrayMethod = "setArray";
    private static final String kSetArrayValue = "ARRAY";
    private static final String kSetUnicodeStreamMethod = "setUnicodeStream";
    private static final String kSetUnicodeStreamValue = "UNICODE_STREAM";
    private static final String kSetBytesMethod = "setBytes";
    private static final String kSetBytesValue = "BYTES";
    private static final String kTruncatedSuffix = "...";

    public PrepStmtSetTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        String method = probe.getProbeMethodName();
        this.fBindParamValue = this.preCalculateParameterValue(method);
        this.isShutOff = !this.configuration.shouldShowSQLParams();
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return this.isShutOff;
    }

    private String preCalculateParameterValue(String method) {
        if (method.equals(kSetNullMethod)) {
            return kSetNullValue;
        }
        if (method.equals(kSetAsciiStreamMethod)) {
            return kSetAsciiStreamValue;
        }
        if (method.equals(kSetBinaryStreamMethod)) {
            return kSetBinaryStreamValue;
        }
        if (method.equals(kSetClobMethod)) {
            return kSetClobValue;
        }
        if (method.equals(kSetBlobMethod)) {
            return kSetBlobValue;
        }
        if (method.equals(kSetCharacterSteamMethod)) {
            return kSetCharacterSteamValue;
        }
        if (method.equals(kSetArrayMethod)) {
            return kSetArrayValue;
        }
        if (method.equals(kSetUnicodeStreamMethod)) {
            return kSetUnicodeStreamValue;
        }
        if (method.equals(kSetBytesMethod)) {
            return kSetBytesValue;
        }
        return null;
    }

    private String getParameterKey(int index) {
        if (index >= 0 && index < kBindParamKeyArray.length) {
            return kBindParamKeyArray[index];
        }
        return kSqlBindParamKey + index;
    }

    private void collectParameter(InvocationData data, int index, Map<String, String> paramList) {
        if (this.fBindParamValue != null) {
            paramList.put(this.getParameterKey(index), this.fBindParamValue);
            return;
        }
        Object param = data.getInvocationParameterAsObject(1);
        if (param == null) {
            paramList.put(this.getParameterKey(index), kSetNullValue);
        } else {
            String str = param.toString();
            if (str.length() < this.configuration.getMaxSQLParamLength()) {
                paramList.put(this.getParameterKey(index), str);
            } else {
                paramList.put(this.getParameterKey(index), str.substring(0, this.configuration.getMaxSQLParamLength()) + kTruncatedSuffix);
            }
        }
    }

    @Override
    public void ITracer_finishTrace(int i, InvocationData data) {
        Object setIndexObj;
        if (data.getInvocationParameterCount() >= 2 && (setIndexObj = data.getInvocationParameterAsObject(0)) instanceof Integer) {
            int index = (Integer)setIndexObj;
            PreparedStatement prepStmt = (PreparedStatement)data.getInvocationObject();
            Map<String, String> paramList = this.bucketHolder.getParamListFromBucket(prepStmt);
            if (paramList == null) {
                paramList = new HashMap<String, String>();
                this.bucketHolder.putParamListInBucket(prepStmt, paramList);
            }
            this.collectParameter(data, index, paramList);
        }
    }
}

