/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.apmservices.client.nass.publisher;

import com.wily.introscope.agent.apmservices.client.httpclient.APMServicesHostConnection;
import com.wily.introscope.agent.apmservices.client.httpclient.HttpClientFactory;
import com.wily.introscope.agent.apmservices.client.nass.publisher.MetricResponseHandler;
import com.wily.introscope.agent.apmservices.client.sustainability.SustainabilityMetricReporter;
import com.wily.introscope.agent.apmservices.client.utils.APMServiceEndpointURL;
import com.wily.introscope.agent.apmservices.client.utils.APMServicesConnection;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.nio.charset.Charset;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class MetricPublisher {
    private APMServicesConnection apmServicesConnection;
    private IModuleFeedbackChannel logger;
    private String extensionName;

    public MetricPublisher(APMServicesConnection apmServicesConnection, IModuleFeedbackChannel logger, String extensionName) {
        this.apmServicesConnection = apmServicesConnection;
        this.logger = logger;
        this.extensionName = extensionName;
    }

    public Integer publishMetricRecords(List<AgentMetricData> agentMetricDataList, boolean async) {
        Integer result = 0;
        try {
            long startTime = System.currentTimeMillis();
            APMServicesHostConnection hostConnection = this.apmServicesConnection.getApmServicesHostConnection();
            Request.Builder httpReq = new Request.Builder();
            httpReq.addHeader("authorization", String.format("Bearer %s", this.apmServicesConnection.getCredential()));
            httpReq.addHeader("content-type", "application/json");
            httpReq.url(hostConnection.getConnectionURL("/nass/metricValue/store"));
            String postBody = this.createNASSValuePayload(agentMetricDataList);
            this.logger.debug("sending metric vales to  NASS :" + postBody);
            httpReq.post(RequestBody.create((MediaType)APMServiceEndpointURL.JSON, (String)new String(postBody.getBytes(), Charset.forName("UTF-8"))));
            MetricResponseHandler metricResponseHandler = new MetricResponseHandler(this.logger, this.extensionName, agentMetricDataList.size());
            if (async) {
                HttpClientFactory.executeRequestAsync(httpReq.build(), metricResponseHandler);
            } else {
                Response response = HttpClientFactory.executeRequestSync(httpReq.build());
                metricResponseHandler.onResponse(null, response);
                result = metricResponseHandler.numRecordsLoaded;
            }
            long totalTime = System.currentTimeMillis() - startTime;
            SustainabilityMetricReporter.reportLongCounter("Agent Stats|Sustainability|APM Services Client|NASS:Metric Store Average Response Time(ms)", totalTime);
        }
        catch (Exception e1) {
            this.logger.error("Exception encountered when sending metric:  " + e1);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public String createNASSValuePayload(List<AgentMetricData> agentMetricDataList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private double asDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            this.logger.error("Error parsing value to double: " + value, (Throwable)e);
            return 0.0;
        }
    }

    boolean isStringType(int type) {
        return type == 21 || type == 5 || type == 8197 || type == 4101 || type == 8453;
    }
}

