/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.apmservices.client.service;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.apmservices.client.api.MetadataServiceAPI;
import com.wily.introscope.agent.apmservices.client.api.NASSServiceAPI;
import com.wily.introscope.agent.apmservices.client.service.MetadataService;
import com.wily.introscope.agent.apmservices.client.service.NASSService;
import com.wily.introscope.agent.apmservices.client.utils.APMServicesConnection;
import com.wily.introscope.agent.nass.NassMetricService;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.Arrays;

public class APMServicesClientAPIService
implements NassMetricService {
    public static final String INTROSCOPE_AGENT_NASS_METRIC_BATCH = "introscope.agent.nass.metric.batch";
    private volatile APMServicesConnection connection;
    private volatile MetadataServiceAPI metadataServiceAPI;
    private volatile NASSServiceAPI nassServiceAPI;
    private IModuleFeedbackChannel fFeedback;
    private static final Module kModule = new Module("APMServicesClientAPIService");
    public static Integer BATCH_TO_PROCESS = 100000;

    public APMServicesClientAPIService(IAgent agent, String extensionName) {
        this.fFeedback = agent.IAgent_getModuleFeedback();
    }

    public void connect(IAgent agent) {
        try {
            this.connection = new APMServicesConnection(agent);
            this.metadataServiceAPI = new MetadataService(agent, this.connection, "");
            this.nassServiceAPI = new NASSService(agent, this.connection, this.metadataServiceAPI, "");
            BATCH_TO_PROCESS = agent.IAgent_getIndexedProperties().getIntProperty(INTROSCOPE_AGENT_NASS_METRIC_BATCH, BATCH_TO_PROCESS.intValue());
            this.fFeedback.info(kModule, "NassServiceAPI connection initialized");
        }
        catch (Throwable ex) {
            this.fFeedback.error(kModule, "Error seen during NassServiceAPI connection initialization with classpath ", ex);
        }
    }

    public void sendMetricCommand(String agentSource, AgentMetricData[] agentMetricsData, AgentMetric[] deadMetrics, boolean firstTimeSlice) {
        if (this.nassServiceAPI != null) {
            this.nassServiceAPI.sendBatchMetric(agentSource, Arrays.asList(agentMetricsData), firstTimeSlice);
        } else {
            this.fFeedback.error(kModule, "NassServiceAPI is not yet initialized");
        }
    }
}

