/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizdef.operations;

import com.wily.introscope.agent.bizdef.BizDefEncapsulatedPattern;
import com.wily.introscope.agent.bizdef.IBizOperationType;
import com.wily.introscope.agent.bizdef.adt.CaseSensitiveMap;
import com.wily.introscope.agent.bizdef.operations.AbstractRegexOperation;
import com.wily.introscope.agent.bizdef.operations.BizNotEqualOperation;
import com.wily.introscope.agent.bizdef.operations.IBizAction;
import java.util.regex.Matcher;

public class BizRegexValueMatchOperation
extends AbstractRegexOperation
implements IBizAction {
    private final String fName = "REGEX_VALUE_OPERATION";
    private IBizOperationType fType;

    public BizRegexValueMatchOperation(IBizOperationType type) {
        this.fType = type;
    }

    @Override
    public boolean matches(BizDefEncapsulatedPattern pattern, String value, boolean caseSensitiveValue) {
        Matcher patternMatcher;
        if (pattern == null && value == null) {
            return false;
        }
        String valueString = value;
        if (BizRegexValueMatchOperation.paramValueExceedSize(valueString)) {
            return false;
        }
        String patternString = pattern.getReplacedPattern();
        if (!caseSensitiveValue) {
            patternString = pattern.getLowercaseReplacedPattern();
            valueString = valueString.toLowerCase();
        }
        if ((patternMatcher = BizRegexValueMatchOperation.getMatcher(patternString, valueString)) != null) {
            return patternMatcher.matches();
        }
        return false;
    }

    @Override
    public boolean matches(Object parameter, BizDefEncapsulatedPattern name, BizDefEncapsulatedPattern pattern, CaseSensitiveMap parameterMap, boolean caseSensitiveName, boolean caseSensitiveValue) {
        if (name != null && pattern != null && parameterMap != null) {
            Matcher patternMatcher;
            String value = BizNotEqualOperation.findValue(parameter, name, parameterMap, caseSensitiveName, caseSensitiveValue);
            if (value == null) {
                return false;
            }
            if (BizRegexValueMatchOperation.paramValueExceedSize(value)) {
                return false;
            }
            String patternString = pattern.getReplacedPattern();
            if (!caseSensitiveValue) {
                patternString = pattern.getLowercaseReplacedPattern();
                value = value.toLowerCase();
            }
            if ((patternMatcher = BizRegexValueMatchOperation.getMatcher(patternString, value)) == null) {
                return false;
            }
            return patternMatcher.matches();
        }
        return false;
    }

    @Override
    public IBizOperationType getType() {
        return this.fType;
    }

    public String toString() {
        return "REGEX_VALUE_OPERATION";
    }

    public boolean equals(Object arg0) {
        return this.toString().equals(arg0.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

