/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.PlatformServerConnectionManager;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.text.IStringLocalizer;

class PlatformConnectionThread
implements Runnable {
    private static final Module sModule = new Module("ConnectionThread");
    private static final int kMaxMessageCount = 10;
    private final PlatformServerConnectionManager fServerConnectionManager;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final ConfigurationManager fConfigurationManager;
    private static volatile String agentCompatibilityVersion = null;

    public PlatformConnectionThread(PlatformServerConnectionManager connectionManager, ConfigurationManager configurationManager) {
        this.fServerConnectionManager = connectionManager;
        this.fFeedback = connectionManager.getFeedbackChannel();
        this.fLocalizer = connectionManager.getStringLocalizer();
        this.fConfigurationManager = configurationManager;
        ConfigurationProperty agentCompatibilityVersionProperty = new ConfigurationProperty("introscope.agent.connection.compatibility.version", null, this.fFeedback, sModule, this.fLocalizer){

            @Override
            public void set(Object value) {
                agentCompatibilityVersion = (String)value;
            }
        };
        configurationManager.add(agentCompatibilityVersionProperty, true);
        this.getFeedbackChannel().info(sModule, "introscope.agent.connection.compatibility.version is set to : " + agentCompatibilityVersion);
    }

    @Override
    public void run() {
        while (true) {
            this.sendData();
        }
    }

    private void sendData() {
        try {
            boolean keepSending = true;
            while (keepSending) {
                long startTime = MasterClock.currentTimeMillis();
                keepSending = this.getServerConnectionManager().sendData();
                long sleepTime = this.getServerConnectionManager().getAgentHarvestTimeMillis() - (MasterClock.currentTimeMillis() - startTime);
                if (sleepTime < 1L) {
                    sleepTime = 1L;
                } else if (sleepTime > this.getServerConnectionManager().getAgentHarvestTimeMillis()) {
                    sleepTime = this.getServerConnectionManager().getAgentHarvestTimeMillis();
                }
                Thread.sleep(sleepTime);
            }
        }
        catch (Throwable t) {
            this.getFeedbackChannel().error(sModule, "ConnectionThread caught throwable while sending data", t);
        }
    }

    private PlatformServerConnectionManager getServerConnectionManager() {
        return this.fServerConnectionManager;
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    public boolean is10dot7CompatibilityModeEnabled() {
        if (this.fConfigurationManager != null) {
            return agentCompatibilityVersion != null && agentCompatibilityVersion.startsWith("10.7");
        }
        return false;
    }
}

