/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.IAgentCommand;
import com.wily.introscope.agent.connection.IAgentHarvester;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.connection.NamedAgentBridgeInfo;
import com.wily.introscope.agent.connection.NamedAgentBridgeVisitor;
import com.wily.introscope.agent.connection.PlatformConnectionThread;
import com.wily.introscope.agent.connection.PlatformHarvestThread;
import com.wily.introscope.agent.connection.PlatformReportingQueue;
import com.wily.introscope.agent.connection.PlatformTimesliceAgentCommand;
import com.wily.introscope.agent.connection.ServerConnectionManager;
import com.wily.introscope.agent.enterprise.IServerConnectionManager;
import com.wily.introscope.agent.enterprise.IServerConnectionObserver;
import com.wily.introscope.agent.nass.NassMetricService;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.isengard.message.MessageUndeliverableException;
import com.wily.util.INameChangeListener;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.thread.IThreadFactory;
import java.util.List;
import java.util.Map;

public class PlatformServerConnectionManager
extends ServerConnectionManager
implements IServerConnectionManager {
    private static final Module sModule = new Module("PlatformServerConnectionManager");
    private static volatile NassMetricService fNassMetricsService = null;
    private final PlatformReportingQueue fReportingQueue;
    private final IStringLocalizer fLocalizer;
    private final IAgentHarvester fHarvester;
    private volatile String fRequestedAgentName;
    private volatile String fActualAgentName;
    private final Thread fConnectionThread;
    private final PlatformConnectionThread fConnectionRunnable;
    private final Thread fHarvestThread;
    private final PlatformHarvestThread fHarvestRunnable;
    private static boolean fSendHistoricalData = true;
    private volatile IsengardServerConnectionManager fServerConnection;

    public PlatformServerConnectionManager(String requestedAgentName, IModuleFeedbackChannel feedback, IStringLocalizer localizer, IThreadFactory threadFactory, IAgentHarvester harvester, ConfigurationManager manager) {
        super(feedback);
        this.fActualAgentName = this.fRequestedAgentName = requestedAgentName;
        this.fReportingQueue = new PlatformReportingQueue(manager, localizer, feedback);
        this.fLocalizer = localizer;
        this.fHarvester = harvester;
        this.fConnectionRunnable = new PlatformConnectionThread(this, manager);
        this.fConnectionThread = threadFactory.IThreadFactory_createNewThread("Agent ServerConnection", this.fConnectionRunnable);
        this.fHarvestRunnable = new PlatformHarvestThread(this, this.fReportingQueue, manager);
        this.fHarvestThread = threadFactory.IThreadFactory_createNewThread("Agent Harvest", this.fHarvestRunnable);
        this.fServerConnection = this.getAgent().IAgent_getIsengardServerConnection();
    }

    @Override
    public void addConnectionObserver(IServerConnectionObserver observer) {
    }

    public void addConnectionObserver(IServerConnectionNotification notification) {
        notification.connectionUp();
    }

    public void connectionUp() {
        this.fReportingQueue.connectionUp();
    }

    @Override
    public void connect() {
        if (PlatformServerConnectionManager.getNassMetricsService() != null) {
            this.getFeedbackChannel().info("connecting fNassMetricsService");
            PlatformServerConnectionManager.getNassMetricsService().connect(this.getAgent());
        } else {
            this.getFeedbackChannel().warn("connect fNassMetricsService is null");
        }
        if (!this.fConnectionThread.isAlive()) {
            this.getFeedbackChannel().trace(sModule, "connect");
            this.fConnectionThread.start();
        } else {
            this.getFeedbackChannel().trace(sModule, "ServerConnection thread is alive: not connecting");
        }
        if (!this.fHarvestThread.isAlive()) {
            this.fHarvestThread.start();
        }
    }

    @Override
    public String getActualAgentName() {
        return null;
    }

    @Override
    public void reportTransactions(TransactionComponentData[] transactions) {
        this.fServerConnection.reportTransactions(transactions);
    }

    @Override
    public void reportTimeslice(AgentMetric[] newMetrics, AgentMetricData[] timeslicedBindings, AgentMetric[] deadMetrics, int timesliceType) {
        this.reportTimeslice(timeslicedBindings, deadMetrics, timesliceType);
    }

    @Override
    protected void connectNamedAgentBridge(NamedAgentBridgeInfo entry) {
        this.fServerConnection.connectNamedAgentBridge(entry);
    }

    @Override
    public boolean reportClientNameChange(String newName) {
        return false;
    }

    @Override
    public void addNegotiatedNameChangeListener(INameChangeListener listener) {
        this.fServerConnection.addNegotiatedNameChangeListener(listener);
    }

    @Override
    public void removeNegotiatedNameChangeListener(INameChangeListener listener) {
        this.fServerConnection.removeNegotiatedNameChangeListener(listener);
    }

    @Override
    public void addNamedAgentBridge(String name, String host, String ipAddr, String process, String agent) {
        this.fServerConnection.addNamedAgentBridge(name, host, ipAddr, process, agent);
    }

    @Override
    public void addNamedAgentBridge(String name, String host, String ipAddr, String process, String agent, String type) {
        this.fServerConnection.addNamedAgentBridge(name, host, ipAddr, process, agent, type);
    }

    @Override
    public void removeNamedAgentBridge(String name) {
        this.fServerConnection.removeNamedAgentBridge(name);
    }

    @Override
    public void acceptNamedAgentBridgeVisitor(NamedAgentBridgeVisitor v) {
        this.fServerConnection.acceptNamedAgentBridgeVisitor(v);
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void setMetricShutoffState(AgentMetric metric, boolean isShutoff) {
    }

    @Override
    protected void reportNamedAgentMetrics(int timesliceType, Map deadMetricsMap, String name, List bindings, NamedAgentBridgeInfo entry) {
        String qualifiedAgent;
        if (entry != null && (qualifiedAgent = "SuperDomain|" + entry.getHost() + "|" + entry.getProcess() + "|" + entry.getAgentName()) != null && bindings != null && !bindings.isEmpty()) {
            this.reportQualifiedAgentMetrics(timesliceType, deadMetricsMap, name, bindings, qualifiedAgent);
        }
    }

    public boolean addToReportingQueue(IAgentCommand command) {
        this.getFeedbackChannel().trace(sModule, "addToPlatformReportingQueue");
        return this.fReportingQueue.add(command);
    }

    @Override
    protected boolean addToReportingQueue(String name, int timesliceType, List<AgentMetric> deadMetricsList, AgentMetricData[] allbindings, String qualifiedAgent) {
        AgentMetric[] emptyArray = new AgentMetric[]{};
        AgentMetric[] dead = deadMetricsList != null ? deadMetricsList.toArray(emptyArray) : emptyArray;
        return this.addToReportingQueue(new PlatformTimesliceAgentCommand(PlatformServerConnectionManager.getNassMetricsService(), this, allbindings, dead, timesliceType == 1, qualifiedAgent != null ? qualifiedAgent : this.fActualAgentName));
    }

    public boolean harvest(int type, boolean harvestTraces) {
        this.fHarvester.harvest(MasterClock.currentTimeMillis(), type, harvestTraces);
        return true;
    }

    public boolean sendData() {
        boolean keepSending = true;
        while (keepSending) {
            try {
                keepSending = this.sendNextItem();
            }
            catch (MessageUndeliverableException mue) {
                return false;
            }
            catch (Exception e) {
                this.getFeedbackChannel().error(sModule, this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_JIP_Protocol_Reporter_Exception_Message"));
                if (this.getFeedbackChannel().isVerboseEnabled(sModule)) {
                    this.getFeedbackChannel().verbose(e);
                }
                return false;
            }
        }
        return true;
    }

    boolean sendNextItem() throws Exception {
        if (this.getFeedbackChannel().isTraceEnabled(sModule)) {
            this.getFeedbackChannel().trace(sModule, "sendNextItem");
        }
        return this.fReportingQueue.handleNextAgentCommand();
    }

    public long getAgentHarvestTimeMillis() {
        return this.fHarvester.getHarvestPeriodInMillis();
    }

    @Override
    protected Module getModule() {
        return sModule;
    }

    public static NassMetricService getNassMetricsService() {
        return fNassMetricsService;
    }

    public static void setNassMetricsService(NassMetricService nassMetricsService) {
        fNassMetricsService = nassMetricsService;
    }

    IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    public void setSendHistoricalData(boolean value) {
        fSendHistoricalData = value;
        if (value) {
            this.fReportingQueue.turnOnBufferingWhileOffline();
        } else {
            this.fReportingQueue.turnOffBufferingWhileOffline();
        }
    }

    public boolean isConnected() {
        return true;
    }

    public static void turnOffSendHistoricalData() {
        fSendHistoricalData = false;
    }

    public static boolean getSendHistoricalData() {
        return fSendHistoricalData;
    }
}

