/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.IAgentCommand;
import com.wily.introscope.agent.connection.PlatformServerConnectionManager;
import com.wily.introscope.agent.nass.NassMetricService;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.wilyassert.Assertion;
import java.io.InvalidClassException;

class PlatformTimesliceAgentCommand
implements IAgentCommand {
    private final NassMetricService fNassMetricsService;
    private final String fActualAgentName;
    private final PlatformServerConnectionManager fManager;
    private final AgentMetricData[] fBindings;
    private final AgentMetric[] fDeadMetrics;
    private final boolean fIsFirstTimeSlice;
    private final long fSizeInMetrics;
    private final long fTimeStamp;
    private volatile long fSizeInBytes = 0L;

    public PlatformTimesliceAgentCommand(NassMetricService nassMetricsService, PlatformServerConnectionManager manager, AgentMetricData[] bindings, AgentMetric[] deadMetrics, boolean firstTimeSlice, String actualAgentName) {
        this.fNassMetricsService = nassMetricsService;
        this.fManager = manager;
        this.fBindings = bindings;
        this.fDeadMetrics = deadMetrics;
        this.fIsFirstTimeSlice = firstTimeSlice;
        this.fSizeInMetrics = bindings.length;
        this.fTimeStamp = System.currentTimeMillis();
        this.fActualAgentName = actualAgentName;
        this.checkBindings();
    }

    private void checkBindings() {
        for (int i = 0; i < this.fBindings.length; ++i) {
            if (this.fBindings[i].getAgentMetric() != AgentMetric.kNullAgentMetric) continue;
            Assertion.wilyAssert(false);
        }
    }

    @Override
    public void handleAgentCommand() throws Exception {
        boolean sent = false;
        if (this.fBindings.length > 0) {
            long currentTime;
            long metricTime;
            if (PlatformServerConnectionManager.getSendHistoricalData() && (metricTime = this.fBindings[0].getTimeslicedValue().getStopTimestampInMillis()) < (currentTime = System.currentTimeMillis()) - this.fManager.getAgentHarvestTimeMillis()) {
                try {
                    this.sendMetrics();
                    sent = true;
                }
                catch (Exception mue) {
                    this.fManager.getFeedbackChannel().debug("Failed to send metric timeslice to server:", mue);
                    Throwable cause = mue.getCause();
                    if (cause instanceof ClassNotFoundException || cause instanceof NoClassDefFoundError || cause instanceof InvalidClassException) {
                        this.fManager.getFeedbackChannel().info("Server does not support historical metric data. Turning off metric data buffering feature.");
                        this.fManager.setSendHistoricalData(false);
                    }
                    throw mue;
                }
            }
            if (!sent) {
                this.sendMetrics();
            }
        }
    }

    private void sendMetrics() {
        if (this.fNassMetricsService != null) {
            AgentMetric[] emptyArray = new AgentMetric[]{};
            AgentMetric[] dead = this.fDeadMetrics != null ? this.fDeadMetrics : emptyArray;
            this.fNassMetricsService.sendMetricCommand(this.fActualAgentName, this.fBindings, dead, this.isFirstTimeslice());
        }
    }

    public boolean isFirstTimeslice() {
        return this.fIsFirstTimeSlice;
    }

    public long getSizeInBytes() {
        if (this.fSizeInBytes == 0L) {
            this.fSizeInBytes = this.getObjectSize();
        }
        return this.fSizeInBytes;
    }

    public long getSizeInMetrics() {
        return this.fSizeInMetrics;
    }

    public long getTimestamp() {
        return this.fTimeStamp;
    }

    private long getObjectSize() {
        long size = AInstrumentationHelper.getObjectSize(this);
        if (size == -1L) {
            return -1L;
        }
        size += AInstrumentationHelper.getObjectSize(this.fBindings);
        size += AInstrumentationHelper.getObjectSize(this.fDeadMetrics);
        for (AgentMetricData binding : this.fBindings) {
            size += AInstrumentationHelper.getObjectSize(binding);
            size += AInstrumentationHelper.getObjectSize(binding.getTimeslicedValue());
        }
        return size;
    }
}

