/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.IntegerConfigurationProperty;

public class RuleEngineConfiguration {
    private static final Module iiModule = Logger.getModule();
    public static final String ENTRYPOINT_DETECTION_CANDIDATES_LIMIT_PER_STACK_TRACE_PROPERTY_KEY = "introscope.agent.deep.entrypoint.candidatesLimitPerStackTrace";
    public static final int ENTRYPOINT_DETECTION_CANDIDATES_LIMIT_PER_STACK_TRACE_PROPERTY_DEFAULT_VALUE = 5;
    public static final int ENTRYPOINT_DETECTION_MAX_INITIAL_CANDIDATE_COUNT_PROPERTY_DEFAULT_VALUE = 10;
    public static final String ENTRYPOINT_DETECTION_STACKTRACE_MAX_DEPTH_TRAVERSE_PROPERTY_KEY = "introscope.agent.deep.entrypoint.stackTrace.max.depth.traverse";
    public static final int ENTRYPOINT_DETECTION_STACKTRACE_MAX_DEPTH_TRAVERSE_PROPERTY_DEFAULT_VALUE = 500;
    private static volatile boolean initCompleted = false;
    private static volatile int numInitialEntryPointCandidates = 5;
    private static volatile int maxDepthToTraverseInStackTrace = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(IAgent agent) {
        boolean result = initCompleted;
        if (result) return;
        Class<RuleEngineConfiguration> clazz = RuleEngineConfiguration.class;
        synchronized (RuleEngineConfiguration.class) {
            result = initCompleted;
            if (result) return;
            RuleEngineConfiguration.initializeInitialCandidateCount(agent);
            RuleEngineConfiguration.initializeMaxDepthToTraverse(agent);
            initCompleted = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static void initializeInitialCandidateCount(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IntegerConfigurationProperty maxInitialCandidatesProperty = new IntegerConfigurationProperty(ENTRYPOINT_DETECTION_CANDIDATES_LIMIT_PER_STACK_TRACE_PROPERTY_KEY, 5, "number of initial entry point candidates to detect", "", true, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            @Override
            public boolean validate(Object value) {
                int intValue = (Integer)value;
                return intValue >= 0 && intValue <= 10;
            }

            @Override
            public void set(Object newValue) {
                RuleEngineConfiguration.setNumberOfInitialEntryPointCandidatesToDetect((Integer)newValue);
            }
        };
        configManager.add(maxInitialCandidatesProperty, true);
    }

    private static void initializeMaxDepthToTraverse(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IntegerConfigurationProperty maxRulesProperty = new IntegerConfigurationProperty(ENTRYPOINT_DETECTION_STACKTRACE_MAX_DEPTH_TRAVERSE_PROPERTY_KEY, 500, "maximum depth at which agent will look in a stack trace for entry point", "", false, false, agent.IAgent_getModuleFeedback(), iiModule, agent.IAgent_getStringLocalizer()){

            @Override
            public void set(Object newValue) {
                RuleEngineConfiguration.setMaxDepthToTraverseInStackTrace((Integer)newValue);
            }
        };
        configManager.add(maxRulesProperty, true);
    }

    public static int getNumberOfInitialEntryPointCandidatesToDetect() {
        return numInitialEntryPointCandidates;
    }

    public static void setNumberOfInitialEntryPointCandidatesToDetect(int numInitialCandidates) {
        numInitialEntryPointCandidates = numInitialCandidates;
    }

    public static int getMaxDepthToTraverseInStackTrace() {
        return maxDepthToTraverseInStackTrace;
    }

    public static void setMaxDepthToTraverseInStackTrace(int maxDepthToTraverseInStackTrace) {
        RuleEngineConfiguration.maxDepthToTraverseInStackTrace = maxDepthToTraverseInStackTrace;
    }
}

