/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.remote.arf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.remote.arf.AArfConnection;
import com.wily.introscope.agent.remote.arf.ArfCommandConnection;
import com.wily.introscope.agent.remote.arf.ArfDataConnection;
import com.wily.introscope.agent.remote.arf.ArfException;
import com.wily.introscope.agent.remote.arf.ArfMessage;
import com.wily.introscope.agent.remote.arf.IArfConnectionListener;
import com.wily.introscope.agent.remote.arf.IArfMessageListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.net.SocketException;

public abstract class AArfTransport
implements Runnable {
    private Thread fServerThread;
    private IArfConnectionListener fConnectionListener;
    protected final IAgent fAgent;
    protected final IModuleFeedbackChannel fFeedback;
    protected final Module kModule = new Module("ArfTransport");
    private IArfMessageListener fMessageListener = new IArfMessageListener(){

        @Override
        public void processMessage(AArfConnection conn, ArfMessage message) {
            if (AArfTransport.this.fFeedback.isTraceEnabled(AArfTransport.this.kModule)) {
                AArfTransport.this.fFeedback.trace(AArfTransport.this.kModule, conn.toString() + " Rx: " + message);
            }
        }

        @Override
        public void resetConnection(AArfConnection conn) {
            AArfTransport.this.fFeedback.warn(AArfTransport.this.kModule, "Arf connection has been reset.");
        }

        @Override
        public void processMessageError(AArfConnection conn, String raw, ArfException e) {
            AArfTransport.this.fFeedback.error(AArfTransport.this.kModule, e.getMessage());
            AArfTransport.this.fFeedback.debug(AArfTransport.this.kModule, "Exception while parsing message: " + raw, e);
        }
    };

    public AArfTransport(IAgent agent) {
        this.fAgent = agent;
        this.fFeedback = agent.IAgent_getModuleFeedback();
    }

    public void startServer(IArfConnectionListener connListener, IArfMessageListener msgListener) {
        this.fConnectionListener = connListener;
        if (msgListener != null) {
            this.fMessageListener = msgListener;
        }
        this.fServerThread = new Thread((Runnable)this, "ArfServer");
        this.fServerThread.start();
        this.fFeedback.info(this.kModule, "Server thread started.");
    }

    public void stopServer() throws InterruptedException {
        this.fConnectionListener = null;
        this.fMessageListener = null;
        this.closeServer();
        this.fServerThread.join();
        this.fServerThread = null;
        this.fFeedback.info(this.kModule, "Server thread stopped.");
    }

    protected abstract ArfDataConnection createArfDataConnection(String var1);

    public ArfDataConnection getDataConnection(String address, String processName, String probe, String pid, String instId) {
        ArfDataConnection conn = this.createArfDataConnection(address);
        conn.setListener(this.fMessageListener);
        conn.start();
        ArfMessage m = new ArfMessage("dataConn");
        m.setProgram(processName);
        m.setProbe(probe);
        m.setPid(pid);
        m.setInstId(instId);
        conn.send(m.writeMessage());
        return conn;
    }

    protected abstract ArfCommandConnection createArfCommandConnection(String var1);

    public ArfCommandConnection getCommandConnection(String address, String processName, String probe, String pid, String instId) {
        ArfCommandConnection conn = this.createArfCommandConnection(address);
        conn.setListener(this.fMessageListener);
        conn.start();
        ArfMessage m = new ArfMessage("commandConn");
        m.setProgram(processName);
        m.setProbe(probe);
        m.setPid(pid);
        m.setInstId(instId);
        conn.send(m.writeMessage());
        return conn;
    }

    protected static boolean isCommandConnection(String message) {
        return message.indexOf(":\"commandConn\"") > 0;
    }

    protected static boolean isDataConnection(String message) {
        return message.indexOf(":\"dataConn\"") > 0;
    }

    protected abstract AArfConnection waitForNextConnection() throws SocketException;

    public abstract boolean initServer();

    public abstract boolean closeServer();

    @Override
    public void run() {
        try {
            while (true) {
                AArfConnection connection;
                if ((connection = this.waitForNextConnection()) == null) {
                    continue;
                }
                connection.setListener(this.fMessageListener);
                if (connection instanceof ArfDataConnection) {
                    this.fConnectionListener.openConnection((ArfDataConnection)connection);
                } else if (connection instanceof ArfCommandConnection) {
                    this.fConnectionListener.openConnection((ArfCommandConnection)connection);
                } else {
                    connection.close();
                }
                connection.start();
            }
        }
        catch (Exception e) {
            this.fFeedback.info(this.kModule, "Arf Server caught exception: " + e.getMessage());
            this.fFeedback.debug(e);
            this.fFeedback.info(this.kModule, "Arf Server Thread done.");
            return;
        }
    }
}

