/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sustainability;

import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.sustainability.ISustainabilityService;
import com.wily.introscope.agent.sustainability.ISustainabilityServiceTrace;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.util.adt.IAtomicNumber;
import com.wily.util.adt.IAtomicNumberFactory;

class ProbeInfoOverheadInfo {
    final ProbeInformation info;
    final ILongIntervalCounterDataAccumulator fGlobal;
    final ILongIntervalCounterDataAccumulator fTracers;
    final IIntegerAverageDataAccumulator fPercentage;
    final ISustainabilityService service;
    final IAtomicNumber fGlobalTimeInMethod;
    final IAtomicNumber fTraceTimeInMethod;
    private ISustainabilityServiceTrace trace;

    public ProbeInfoOverheadInfo(ISustainabilityService service, ProbeInformation info) {
        this.service = service;
        this.info = info;
        IAtomicNumberFactory factory = service.getFactory();
        this.fGlobalTimeInMethod = factory.getInstance(0);
        this.fTraceTimeInMethod = factory.getInstance(0);
        if (service.isSustainabilityMetricsEnabled()) {
            String metricName = "Agent Stats|Sustainability|Tracer Overhead|" + info.getProbeIdentification().getProbeClassName() + "|" + info.getProbeIdentification().getProbeMethodName() + ":Global Time";
            this.fGlobal = service.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(metricName);
            metricName = "Agent Stats|Sustainability|Tracer Overhead|" + info.getProbeIdentification().getProbeClassName() + "|" + info.getProbeIdentification().getProbeMethodName() + ":Tracers time";
            this.fTracers = service.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(metricName);
            metricName = "Agent Stats|Sustainability|Tracer Overhead|" + info.getProbeIdentification().getProbeClassName() + "|" + info.getProbeIdentification().getProbeMethodName() + ":Percentage";
            this.fPercentage = service.getAgent().IAgent_getDataAccumulatorFactory().safeGetIntegerPercentageDataAccumulator(metricName);
        } else {
            this.fGlobal = null;
            this.fTracers = null;
            this.fPercentage = null;
        }
    }

    public void setTrace(ISustainabilityServiceTrace trace) {
        this.trace = trace;
    }

    public ISustainabilityServiceTrace getTrace() {
        return this.trace;
    }

    public ProbeInformation getProbeInfo() {
        return this.info;
    }
}

