/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.cas.IGathererElement;
import com.wily.introscope.agent.trace.cas.IUpdater;

public class UpdaterFactory {
    private static final IUpdater kNonCombiningUpdater = new NonCombiningUpdater();
    private static final IUpdater kUpdater = new Updater();
    private static final IUpdater kSubtractingUpdater = new SubtractingUpdater();
    private static final IUpdater kDecreaser = new Decreaser();
    private static final IUpdater kIncreaser = new Increaser();

    public static final IUpdater getCombiningUpdater() {
        return kUpdater;
    }

    public static final IUpdater getSubtractingUpdater() {
        return kSubtractingUpdater;
    }

    public static final IUpdater getDecreasingUpdater() {
        return kDecreaser;
    }

    public static final IUpdater getIncreasingUpdater() {
        return kIncreaser;
    }

    public static final IUpdater getNonCombiningUpdater() {
        return kNonCombiningUpdater;
    }

    static final class NonCombiningUpdater
    implements IUpdater {
        NonCombiningUpdater() {
        }

        @Override
        public final void update(IGathererElement element, long value, long startTime, long endTime) {
            element.setValue(value);
            element.combineTime(startTime);
        }

        @Override
        public final void update(IGathererElement repository, long value, long time) {
            repository.setValue(value);
            repository.combineTime(time);
        }
    }

    static final class SubtractingUpdater
    implements IUpdater {
        SubtractingUpdater() {
        }

        @Override
        public final void update(IGathererElement element, long value, long startTime, long endTime) {
            element.combineValue(-1L * value);
            element.combineTime(startTime);
        }

        @Override
        public final void update(IGathererElement repository, long value, long time) {
            repository.combineValue(-1L * value);
            repository.combineTime(time);
        }
    }

    static final class Updater
    implements IUpdater {
        Updater() {
        }

        @Override
        public final void update(IGathererElement element, long value, long startTime, long endTime) {
            element.combineValue(value);
            element.combineTime(startTime);
        }

        @Override
        public final void update(IGathererElement repository, long value, long time) {
            repository.combineValue(value);
            repository.combineTime(time);
        }
    }

    static final class Decreaser
    implements IUpdater {
        Decreaser() {
        }

        @Override
        public final void update(IGathererElement element, long value, long startTime, long endTime) {
            element.decrease(startTime);
        }

        @Override
        public final void update(IGathererElement repository, long value, long time) {
            repository.decrease(time);
        }
    }

    static final class Increaser
    implements IUpdater {
        Increaser() {
        }

        @Override
        public final void update(IGathererElement element, long value, long startTime, long endTime) {
            element.increase(startTime);
        }

        @Override
        public final void update(IGathererElement repository, long value, long time) {
            repository.increase(time);
        }
    }
}

