/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.synchronizer;

import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.sink.IMessageSink;
import com.wily.isengard.messageprimitives.sink.IRawMessageSink;
import com.wily.isengard.messageprimitives.sink.ISinkNotification;
import com.wily.isengard.messageprimitives.sink.MessageSink;
import com.wily.isengard.messageprimitives.stream.MessageStreamPublisher;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.PostOffice;
import java.lang.reflect.Method;

public class MessageSynchronizer<T>
extends MessageStreamPublisher<T> {
    private LocalSink<T> fLocalSink;
    private boolean fIsPublishing = false;

    public MessageSynchronizer(PostOffice po, Class<T> interfaceClass) throws InvalidIsengardInterface {
        super(po, interfaceClass);
        this.fLocalSink = new LocalSink<T>(po, interfaceClass);
    }

    @Override
    public void close() {
        this.fLocalSink.close();
        super.close();
    }

    public Address getSinkAddress() {
        return this.fLocalSink.getAddress();
    }

    @Override
    protected final void startPublishing() {
        this.fIsPublishing = true;
    }

    @Override
    protected final void stopPublishing() {
        this.fIsPublishing = false;
    }

    @Override
    protected final Object replyToSubscription() {
        return this.fLocalSink.getAddress();
    }

    @Override
    public void SubscriptionsFinished() {
    }

    private class LocalSink<T>
    implements IRawMessageSink,
    ISinkNotification {
        private MessageSink<T> fSink;

        public LocalSink(PostOffice po, Class<T> interfaceClass) throws InvalidIsengardInterface {
            this.fSink = new MessageSink<T>(po, interfaceClass, this);
        }

        public void close() {
            this.fSink.close();
        }

        public Address getAddress() {
            return this.fSink.getAddress();
        }

        @Override
        public Object rawMethodHandler(Method method, int interfaceVersion, Object[] params) {
            if (MessageSynchronizer.this.fIsPublishing) {
                MessageSynchronizer.this.sendData(method, params);
            }
            return null;
        }

        @Override
        public IMessageSink sinkPublisherStarted(Address address) {
            return this;
        }

        @Override
        public void sinkPublisherStopped(Address address) {
        }
    }
}

