/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.http.client;

import com.wily.isengard.postofficehub.link.http.client.HTTPNotRunningException;
import com.wily.isengard.postofficehub.link.http.client.IHttpTunnelingClient;
import com.wily.isengard.postofficehub.link.http.client.ProxyConfiguration;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.NonSyncByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class CommonsHttpTunnelingClient
implements IHttpTunnelingClient {
    public static final DefaultHostnameVerifier DEFAULT_HOSTNAME_VERIFIER = new DefaultHostnameVerifier();
    private static Module sModule = new Module("CommonsHttpTunnelingClient");
    private static final byte[] kEmptyArray = new byte[0];
    private static final String kTunnelingServiceContext = "/em/transport/services/IsengardHttpTunnelingService";
    private static final String kCharset = "UTF-8";
    private static final ContentType kContentType = ContentType.create((String)"text/xml", (String)"UTF-8");
    private static final String kConnectSOAPRequest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:connect soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"/></soapenv:Body></soapenv:Envelope>";
    private static final String kDisconnectSOAPRequest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:disconnect soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"/></soapenv:Body></soapenv:Envelope>";
    private static final String kTransferSOAPRequestStart = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:transfer soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"><in0 xsi:type=\"soapenc:base64Binary\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">";
    private static final String kTransferSOAPRequestEnd = "</in0></ns1:transfer></soapenv:Body></soapenv:Envelope>";
    private static final String kEmptyTransferSOAPRequest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:transfer soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"><in0 xsi:type=\"soapenc:base64Binary\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\"></in0></ns1:transfer></soapenv:Body></soapenv:Envelope>";
    private static final String kTransferSOAPResponseStart = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><ns1:transferResponse soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:ns1=\"urn:isengard.wily.com\"><transferReturn xsi:type=\"soapenc:base64Binary\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">";
    private static final String kTransferSOAPResponseEnd = "</transferReturn></ns1:transferResponse></soapenv:Body></soapenv:Envelope>";
    private static final String kErrorSOAPResponseStart = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body><soapenv:Fault>";
    private static final String kErrorSOAPResponseEnd = "</soapenv:Fault></soapenv:Body></soapenv:Envelope>";
    private static byte[] sTransferSOAPRequestStartBytes;
    private static byte[] sTransferSOAPRequestEndBytes;
    private static byte[] sEmptyTransferSOAPRequestBytes;
    private static int sTransferSOAPResponseStartNumBytes;
    private static int sTransferSOAPResponseEndNumBytes;
    private HttpClient fHttpClient;
    private ClientConnectionManager fConnManager;
    private ProxyConfiguration fProxyConfig;
    private final RequestConfig requestConfig;
    private final SocketConfig socketConfig;
    private HttpRequestRetryHandler retryHandler;
    private String fTunnelingServiceAddress;
    private HttpEntityEnclosingRequestBase fMethod;
    private NonSyncByteArrayOutputStream fOutStream;
    private final String fHostName;
    private final int fPort;
    private final SSLContext fSSLContext;
    private final boolean fValidateHostname;
    private String[] fCipherSuites;
    private String[] fProtocols;
    private boolean fTryIPAddress;
    private IModuleFeedbackChannel fFeedback;

    static {
        try {
            sTransferSOAPRequestStartBytes = kTransferSOAPRequestStart.getBytes(kCharset);
            sTransferSOAPRequestEndBytes = kTransferSOAPRequestEnd.getBytes(kCharset);
            sEmptyTransferSOAPRequestBytes = kEmptyTransferSOAPRequest.getBytes(kCharset);
            sTransferSOAPResponseStartNumBytes = kTransferSOAPResponseStart.getBytes(kCharset).length;
            sTransferSOAPResponseEndNumBytes = kTransferSOAPResponseEnd.getBytes(kCharset).length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Charset UTF-8 is not supported.");
        }
    }

    public CommonsHttpTunnelingClient(String hostName, int port, int socketSendBufferSize, int socketRecieveBufferSize, SSLContext context, boolean validateHostname, String[] cipherSuites, String[] protocols, boolean tryIPAddress, IModuleFeedbackChannel feedback) {
        System.setProperty("com.wily.org.apache.commons.logging.Log", "com.wily.org.apache.commons.logging.impl.NoOpLog");
        this.fHostName = hostName;
        this.fPort = port;
        this.fSSLContext = context;
        this.fValidateHostname = validateHostname;
        this.fCipherSuites = cipherSuites;
        this.fProtocols = protocols;
        this.fFeedback = feedback;
        this.fTryIPAddress = tryIPAddress;
        this.requestConfig = RequestConfig.custom().setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
        this.socketConfig = SocketConfig.custom().setSndBufSize(socketSendBufferSize).setRcvBufSize(socketRecieveBufferSize).setSoKeepAlive(true).setSoTimeout(10000).build();
        this.retryHandler = new DefaultHttpRequestRetryHandler(0, false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void connect() throws HTTPNotRunningException {
        thrownException = null;
        try {
            this.connect2(this.fHostName);
            return;
        }
        catch (HTTPNotRunningException e) {
            thrownException = e;
            if (!this.fTryIPAddress) {
                throw thrownException;
            }
            addresses = new InetAddress[]{};
            try {
                addresses = InetAddress.getAllByName(this.fHostName);
            }
            catch (UnknownHostException v0) {
                throw thrownException;
            }
            var6_4 = addresses;
            var5_5 = addresses.length;
            var4_6 = 0;
            ** while (var4_6 < var5_5)
        }
lbl-1000:
        // 1 sources

        {
            address = var6_4[var4_6];
            ipAddress = address.getHostAddress();
            try {
                this.connect2(ipAddress);
                return;
            }
            catch (HTTPNotRunningException e) {
                thrownException = e;
                ++var4_6;
            }
            continue;
        }
lbl28:
        // 1 sources

        throw thrownException;
    }

    private void connect2(String host) throws HTTPNotRunningException {
        host = this.determineAndFormatIPv6HostAddress(host);
        this.fTunnelingServiceAddress = this.fSSLContext == null ? "http://" + host + ":" + this.fPort + kTunnelingServiceContext : "https://" + host + ":" + this.fPort + kTunnelingServiceContext;
        boolean connected = false;
        this.fMethod = new HttpPost(this.fTunnelingServiceAddress);
        this.fMethod.setConfig(this.requestConfig);
        this.fMethod.setHeader("SOAPAction", "\"\"");
        this.fMethod.getParams().setParameter("http.virtual-host", (Object)new HttpHost(this.fHostName, this.fPort));
        this.fOutStream = new NonSyncByteArrayOutputStream();
        Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).register("NTLM", (Object)new NTLMSchemeFactory()).register("Digest", (Object)new DigestSchemeFactory()).build();
        try {
            try {
                HttpClientBuilder clientBuilder = HttpClients.custom().setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE).setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setDefaultSocketConfig(this.socketConfig).setRetryHandler(this.retryHandler);
                if (this.fSSLContext != null) {
                    SSLConnectionSocketFactory sf = new SSLConnectionSocketFactory(this.fSSLContext, (String[])(this.fProtocols != null && this.fProtocols.length == 0 ? null : this.fProtocols), (String[])(this.fCipherSuites != null && this.fCipherSuites.length == 0 ? null : this.fCipherSuites), (HostnameVerifier)(this.fValidateHostname ? DEFAULT_HOSTNAME_VERIFIER : AcceptAllHostnameVerifier.INSTANCE));
                    clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sf);
                }
                this.enableProxyServerSupport(clientBuilder);
                CloseableHttpClient httpClient = clientBuilder.build();
                this.fConnManager = httpClient.getConnectionManager();
                StringEntity requestEntity = new StringEntity(kConnectSOAPRequest, kContentType);
                requestEntity.setChunked(true);
                this.fMethod.setEntity((HttpEntity)requestEntity);
                HttpResponse status = httpClient.execute((HttpUriRequest)this.fMethod);
                this.fHttpClient = httpClient;
                if (this.getStatusCode(status) != 200) {
                    String faultMsg = this.getFaultMessageAsString(status, kCharset);
                    throw new RemoteException("Error when connecting to tunneling server: " + faultMsg);
                }
                connected = true;
            }
            catch (Exception e) {
                throw new HTTPNotRunningException("The HTTP Tunneling server cannot be reached at: " + this.fTunnelingServiceAddress + ": " + e.getMessage(), e);
            }
        }
        finally {
            this.fMethod.releaseConnection();
            if (!connected) {
                this.closeHttpConnection();
                this.fHttpClient = null;
            }
        }
    }

    private String determineAndFormatIPv6HostAddress(String host) {
        try {
            InetAddress address = InetAddress.getByName(host);
            ClassLoader classLoader = address.getClass().getClassLoader();
            Class<?> inet6AddressCls = Class.forName("java.net.Inet6Address", true, classLoader);
            if (inet6AddressCls.isInstance(address) && (host = address.getHostName()).equals(address.getHostAddress())) {
                host = "[" + URLEncoder.encode(host, kCharset) + "]";
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return host;
    }

    @Override
    public void connect(ProxyConfiguration config) throws HTTPNotRunningException {
        this.fProxyConfig = config;
        this.connect();
    }

    @Override
    public void disconnect() throws IOException {
        if (this.fHttpClient != null) {
            try {
                StringEntity requestEntity = new StringEntity(kDisconnectSOAPRequest, kContentType);
                this.fMethod.setEntity((HttpEntity)requestEntity);
                HttpResponse status = this.fHttpClient.execute((HttpUriRequest)this.fMethod);
                if (this.getStatusCode(status) != 200) {
                    String faultMsg = this.getFaultMessageAsString(status, kCharset);
                    throw new RemoteException("Error when disconnecting from tunneling server: " + faultMsg);
                }
            }
            finally {
                this.fMethod.releaseConnection();
                this.closeHttpConnection();
            }
        }
    }

    @Override
    public byte[] transfer(byte[] serverData) throws IOException {
        byte[] result = kEmptyArray;
        if (this.fHttpClient != null) {
            try {
                byte[] requestBytes = this.getTransferRequest(serverData);
                ByteArrayEntity requestEntity = new ByteArrayEntity(requestBytes, kContentType);
                this.fMethod.setEntity((HttpEntity)requestEntity);
                HttpResponse status = this.fHttpClient.execute((HttpUriRequest)this.fMethod);
                if (this.getStatusCode(status) != 200) {
                    String faultMsg = this.getFaultMessageAsString(status, kCharset);
                    throw new RemoteException("Error when transfering data to/from tunneling server: " + faultMsg);
                }
                byte[] responseBytes = this.getResponse(status);
                int transferedDataLength = responseBytes.length - sTransferSOAPResponseStartNumBytes - sTransferSOAPResponseEndNumBytes;
                if (transferedDataLength == 0) {
                    result = kEmptyArray;
                } else {
                    byte[] transferedData = new byte[transferedDataLength];
                    System.arraycopy(responseBytes, sTransferSOAPResponseStartNumBytes, transferedData, 0, transferedDataLength);
                    result = Base64.decodeBase64((byte[])transferedData);
                }
            }
            finally {
                this.fMethod.releaseConnection();
            }
        }
        return result;
    }

    private void enableProxyServerSupport(HttpClientBuilder clientBuilder) {
        if (this.fProxyConfig != null) {
            Logger.getLogger(CredentialsProvider.class.getName()).setLevel(Level.WARNING);
            clientBuilder.setProxy(new HttpHost(this.fProxyConfig.getHostName(), this.fProxyConfig.getPort()));
            if (this.fProxyConfig.requiresAuthentication()) {
                UsernamePasswordCredentials creds;
                AuthScope scope = new AuthScope(this.fProxyConfig.getHostName(), -1, this.fProxyConfig.getRealm());
                String username = this.fProxyConfig.getUserName();
                if (!username.contains("\\")) {
                    creds = new UsernamePasswordCredentials(username, this.fProxyConfig.getPassword());
                } else {
                    String[] domainUsername = username.split("\\\\");
                    String hostname = "";
                    try {
                        InetAddress addr = InetAddress.getLocalHost();
                        hostname = addr.getHostName();
                        if (hostname != null) {
                            if (hostname.contains(".")) {
                                int hostIndex = hostname.lastIndexOf(".");
                                hostname = hostname.substring(hostIndex);
                            }
                        } else {
                            hostname = addr.getHostAddress();
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        hostname = "";
                    }
                    creds = new NTCredentials(domainUsername[1], this.fProxyConfig.getPassword(), hostname, domainUsername[0]);
                    this.fFeedback.verbose(sModule, "NTLM Proxy Credentials: Domain: " + domainUsername[0] + ", Host:" + hostname + ", User Name: " + domainUsername[1]);
                }
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(scope, (Credentials)creds);
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
    }

    private byte[] getTransferRequest(byte[] serverData) {
        byte[] requestBytes = null;
        if (serverData.length > 0) {
            byte[] encodedData = Base64.encodeBase64((byte[])serverData);
            requestBytes = new byte[sTransferSOAPRequestStartBytes.length + encodedData.length + sTransferSOAPRequestEndBytes.length];
            System.arraycopy(sTransferSOAPRequestStartBytes, 0, requestBytes, 0, sTransferSOAPRequestStartBytes.length);
            System.arraycopy(encodedData, 0, requestBytes, sTransferSOAPRequestStartBytes.length, encodedData.length);
            System.arraycopy(sTransferSOAPRequestEndBytes, 0, requestBytes, sTransferSOAPRequestStartBytes.length + encodedData.length, sTransferSOAPRequestEndBytes.length);
        } else {
            requestBytes = sEmptyTransferSOAPRequestBytes;
        }
        return requestBytes;
    }

    private String getFaultMessageAsString(HttpResponse resp, String charset) throws IOException {
        String response = this.getResponseAsString(resp, charset);
        return response.substring(kErrorSOAPResponseStart.length(), response.length() - kErrorSOAPResponseEnd.length());
    }

    private String getResponseAsString(HttpResponse resp, String charset) throws IOException {
        return new String(this.getResponse(resp), charset);
    }

    private byte[] getResponse(HttpResponse resp) throws IOException {
        InputStream inStream = resp.getEntity().getContent();
        NonSyncByteArrayOutputStream outStream = this.fOutStream;
        byte[] responseBytes = null;
        try {
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = inStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, len);
            }
            responseBytes = outStream.toByteArray();
        }
        finally {
            outStream.reset();
        }
        return responseBytes;
    }

    private void logSocketBufferSizes() {
        System.out.println("HttpClient Tunneling Client Connecting:  SO_SNDBUF=" + this.socketConfig.getSndBufSize() + ", SO_RCVBUF=" + this.socketConfig.getRcvBufSize());
    }

    private void closeHttpConnection() {
        if (this.fConnManager != null) {
            this.fConnManager.closeIdleConnections(0L, TimeUnit.SECONDS);
        }
    }

    private int getStatusCode(HttpResponse resp) {
        StatusLine statusLine = resp.getStatusLine();
        if (statusLine != null) {
            return statusLine.getStatusCode();
        }
        return -1;
    }

    private static class AcceptAllHostnameVerifier
    implements HostnameVerifier {
        public static final AcceptAllHostnameVerifier INSTANCE = new AcceptAllHostnameVerifier();

        private AcceptAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

