/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.dataresolver;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.utilities.UrlUtilities;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.Module;
import java.net.URI;

public class ApacheHttpCommonsClientDataResolver
implements HttpDataResolver {
    private static Module module = new Module("ApacheHttpCommonsClientDataResolver");
    private static final HttpDataResolver instance = new ApacheHttpCommonsClientDataResolver();

    private ApacheHttpCommonsClientDataResolver() {
    }

    public static HttpDataResolver getInstance() {
        return instance;
    }

    @Override
    public URI getUri(IAgent agent, InvocationData data) {
        boolean verbose = agent.IAgent_getModuleFeedback().isVerboseEnabled(module);
        boolean traceOn = agent.IAgent_getModuleFeedback().isTraceEnabled(module);
        Object url = null;
        Object uriObject = null;
        try {
            uriObject = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationParameterAsObject(1), (String)"getURI", (Class[])new Class[0], (Object[])new Object[0]);
            url = ReflectionUtils.invokeMethodOnObject((Object)uriObject, (String)"getRawURI", (Class[])new Class[0], (Object[])new Object[0]);
            if (url != null) {
                String urlString = new String((char[])url);
                URI uri = URI.create(UrlUtilities.encodeSpecialChars(agent, UrlUtilities.formatSpecialChars(urlString.trim())));
                if (!uri.isAbsolute()) {
                    Object hostConfiguration = data.getInvocationParameterAsObject(0);
                    if (hostConfiguration == null) {
                        hostConfiguration = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationObject(), (String)"getHostConfiguration", (Class[])new Class[0], (Object[])new Object[0]);
                    }
                    if (hostConfiguration != null) {
                        Object hostObjectUri = ReflectionUtils.invokeMethodOnObject((Object)hostConfiguration, (String)"getHostURL", (Class[])new Class[0], (Object[])new Object[0]);
                        if (hostObjectUri != null) {
                            uri = URI.create((String)hostObjectUri + uri.toString());
                        } else {
                            return BackendProtocolsConstants.UNKNOWN_URI;
                        }
                    }
                }
                if (traceOn) {
                    agent.IAgent_getModuleFeedback().trace(module, "URI (post percent encoding): " + uri.toASCIIString());
                }
                return uri;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().debug(module, "URI extraced from attributes after an exception ");
                if (uriObject != null) {
                    String schema = (String)ReflectionUtils.invokeMethodOnObject((Object)uriObject, (String)"getScheme", (Class[])new Class[0], (Object[])new Object[0]);
                    String host = (String)ReflectionUtils.invokeMethodOnObject((Object)uriObject, (String)"getHost", (Class[])new Class[0], (Object[])new Object[0]);
                    Integer port = (Integer)ReflectionUtils.invokeMethodOnObject((Object)uriObject, (String)"getPort", (Class[])new Class[0], (Object[])new Object[0]);
                    String path = (String)ReflectionUtils.invokeMethodOnObject((Object)uriObject, (String)"getPath", (Class[])new Class[0], (Object[])new Object[0]);
                    path = path == null ? "" : path;
                    String string = path = path.startsWith("/") ? path : "/" + path;
                    if (host == null || schema == null) {
                        data.put("HttpURI.Path.Key.Invalid", (Object)path);
                        return BackendProtocolsConstants.INVALID_URI;
                    }
                    URI newURI = new URI(schema, null, host, port, path, null, null);
                    agent.IAgent_getModuleFeedback().warn(module, "URI extraced from attributes after an exception - " + newURI);
                    return newURI;
                }
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable t2) {
                try {
                    agent.IAgent_getModuleFeedback().error(module, "getURI : Unable to get URL for Apache Http commons client -" + url);
                    agent.IAgent_getModuleFeedback().debug(t2);
                }
                catch (ThreadDeath td3) {
                    throw td3;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return BackendProtocolsConstants.UNKNOWN_URI;
    }

    @Override
    public String getHttpMethod(IAgent agent, InvocationData data) {
        try {
            Object httpMethod = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationParameterAsObject(1), (String)"getName", (Class[])new Class[0], (Object[])new Object[0]);
            if (httpMethod != null && httpMethod instanceof String) {
                return (String)httpMethod;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getHttpMethod() : Unable to get HTTP method");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public int getHttpStatusCode(IAgent agent, InvocationData data) {
        try {
            Object responseCode = data.getInvocationReturnValueAsObject();
            if (responseCode != null) {
                return (Integer)responseCode;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getHttpStatusCode() : Unable to get response code");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public String getHttpStatusMessage(IAgent agent, InvocationData data) {
        try {
            Object responseMessage = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationParameterAsObject(1), (String)"getStatusText", (Class[])new Class[0], (Object[])new Object[0]);
            if (responseMessage != null) {
                return (String)responseMessage;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getHttpStatusMessage() : Unable to get response status message");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

