/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.frontend.jms;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.frontend.jms.JMSReceiveSharedTracerHelper;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationProperty;

public class JMSReceiveParentTracer
extends ASingleMetricTracerFactory
implements BackendProtocolsConstants {
    private static volatile boolean jmsTransactionTraceEnabled = true;
    private static final Module ModuleName = new Module("JMSReceiverParentTracer");
    static final IUpdater kUpdater = UpdaterFactory.getCombiningUpdater();

    private static void initTraceProperty(IAgent agent) {
        agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new JMSReceiveTransactionTraceProperty(agent));
    }

    public JMSReceiveParentTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        super.ITracer_startTrace(tracerIndex, data);
        JMSReceiveSharedTracerHelper.JMSReceiveTxnCache cache = JMSReceiveSharedTracerHelper.getJMSReceiveTxnCache(data);
        cache.isParentTracerAvailable = true;
        data.put("ParentMarker", (Object)Boolean.TRUE);
    }

    public static boolean isTxnTraceEnabled() {
        return jmsTransactionTraceEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Boolean result = (Boolean)data.get("ParentMarker");
        if (result == null || !result.booleanValue()) {
            return;
        }
        try {
            super.ITracer_finishTrace(tracerIndex, data);
        }
        catch (Exception exception) {
            try {
                JMSReceiveSharedTracerHelper.finishTxnTraceForReceive(data, true);
            }
            finally {
                JMSReceiveSharedTracerHelper.clearJMSReceiveTxnCache(data);
                JMSHelper.debug(ModuleName, "Cleared the Receive Txn Cache. " + Thread.currentThread());
            }
        }
        finally {
            try {
                JMSReceiveSharedTracerHelper.finishTxnTraceForReceive(data, true);
            }
            finally {
                JMSReceiveSharedTracerHelper.clearJMSReceiveTxnCache(data);
                JMSHelper.debug(ModuleName, "Cleared the Receive Txn Cache. " + Thread.currentThread());
            }
        }
    }

    public void offerNewTransactionInstanceElementOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
    }

    public void offerNewTransactionInstanceElementOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
    }

    protected IRepository getRepository(InvocationData data, ISharedMetricHolder holder) {
        return null;
    }

    protected void doOnStartTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOnEndTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
        long lastReceivedTime = -1L;
        JMSReceiveSharedTracerHelper.JMSReceiveTxnCache cache = null;
        try {
            cache = JMSReceiveSharedTracerHelper.getJMSReceiveTxnCache((InvocationData)data);
            lastReceivedTime = cache.lastReceiveTimeInThisThread;
            if (lastReceivedTime != -1L) {
                long elapsed = data.getWallClockFinishTime() - lastReceivedTime;
                IRepository repository = cache.estimatedTimeRepo;
                this.updateMessageProcessingRep(data, lastReceivedTime, elapsed >= 0L ? elapsed : 0L, repository);
                IRepository aggregatedRepository = cache.aggregatedEstimatedTimeRepo;
                this.updateMessageProcessingRep(data, lastReceivedTime, elapsed >= 0L ? elapsed : 0L, aggregatedRepository);
            }
        }
        finally {
            if (lastReceivedTime != -1L) {
                cache.isParentTracerAvailable = false;
            }
        }
    }

    private void updateMessageProcessingRep(IStackElement data, Long lastReceivedTime, long elapsed, IRepository repository) {
        if (repository != null) {
            repository.update(kUpdater, elapsed, lastReceivedTime.longValue(), data.hashCode());
        }
    }

    static {
        try {
            IAgent agent = AgentShim.getAgent();
            if (agent != null) {
                JMSReceiveParentTracer.initTraceProperty(agent);
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            // empty catch block
        }
    }

    static final class JMSReceiveTransactionTraceProperty
    extends BooleanConfigurationProperty {
        private JMSReceiveTransactionTraceProperty(IAgent agent) {
            super("jms.receive.txntracing.enabled", Boolean.TRUE, agent.IAgent_getModuleFeedback(), BackendProtocolsConstants.kJMSGenericSupportModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            jmsTransactionTraceEnabled = (Boolean)newValue;
        }
    }
}

