/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.jmxclient.transformers.compositedata;

import com.ca.agent.jmxclient.transformers.compositedata.MaxValue;
import com.ca.agent.jmxclient.transformers.compositedata.UsedValue;
import com.ca.apm.agent.jmxclient.metrics.MetricValueTransformer;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;

public class UsedMaxPercentageValue<T extends CompositeDataSupport>
implements MetricValueTransformer<T, Number> {
    private final UsedValue used = new UsedValue();
    private final MaxValue max = new MaxValue();

    @Override
    public Number transform(T value, Map info) {
        long usedMem = this.used.transform(value, info).longValue();
        long maxMem = this.max.transform(value, info).longValue();
        if (maxMem <= 0L || usedMem > maxMem) {
            return -1;
        }
        Double p = (double)usedMem * 100.0 / (double)maxMem + 0.5;
        return p.longValue();
    }

    @Override
    public boolean validate(Object value) {
        return value instanceof CompositeDataSupport;
    }
}

