/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.atc;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.Constants;
import com.ca.apm.agent.jmxclient.Utils;
import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.ca.apm.agent.jmxclient.atc.ApmData;
import com.ca.apm.agent.jmxclient.atc.Graph;
import com.ca.apm.agent.jmxclient.atc.Vertex;
import com.google.gson.Gson;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpCallClient;
import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpResponse;
import com.wily.isengard.postoffice.PostOffice;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Adler32;

public final class AtcConnectionManager
implements IServerConnectionNotification {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private final IsengardServerConnectionManager serverConnManager;
    boolean atcPostFailed = false;
    int atcPostLogCounter = 0;
    private final long graphTtl;
    private final long graphResendInterval;
    private final ScheduledThreadPoolExecutor executor;
    private volatile boolean isConnectionUp = false;
    private final Map<String, AtcJmxVertex> updatedVertices = new HashMap<String, AtcJmxVertex>();

    public AtcConnectionManager(ScheduledThreadPoolExecutor executor) {
        this.executor = executor;
        this.graphTtl = Configuration.getGraphTimeToLive();
        this.graphResendInterval = Configuration.geGraphResendInterval();
        this.serverConnManager = Configuration.getAgent().IAgent_getIsengardServerConnection();
        this.registerWithServer(this);
    }

    private void registerWithServer(AtcConnectionManager manager) {
        if (this.serverConnManager != null) {
            this.serverConnManager.addConnectionObserver((IServerConnectionNotification)manager);
        }
    }

    public void connectionDown() {
        this.isConnectionUp = false;
        LOGGER.logDebugMessage("Agent/EM Connection is down.");
    }

    public void connectionUp() {
        this.isConnectionUp = true;
        LOGGER.logDebugMessage("Agent/EM Connection is up. Posting new Configuration");
        Callable<Boolean> task = new Callable<Boolean>(){
            AtomicInteger delay = new AtomicInteger(15);
            AtomicInteger attempts = new AtomicInteger(0);
            final int maxAttempts = 5;

            @Override
            public Boolean call() throws Exception {
                LOGGER.logDebugMessage("Posting JMX Configuration");
                boolean success = AtcConnectionManager.this.postATCData("/apm/appmap/ats/extension/configure", Utils.loadJsonAsString("/jmx-atc-template.json"));
                if (!success && this.attempts.incrementAndGet() < 5) {
                    this.delay.set(Math.min(2 * this.delay.get(), 600));
                    LOGGER.logDebugMessage("Failed to post JMX Configuration. Next attempt (" + this.attempts.get() + ") in " + this.delay + " seconds.");
                    AtcConnectionManager.this.executor.schedule(this, (long)this.delay.get(), TimeUnit.SECONDS);
                }
                return success;
            }
        };
        try {
            if (!this.executor.isShutdown()) {
                this.executor.submit(task);
            }
        }
        catch (Exception e) {
            LOGGER.logDebugMessage(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isConnectionUp() {
        return this.isConnectionUp;
    }

    public boolean postATCData(String endPoint, String jsonData) {
        try {
            if (this.serverConnManager.getConnectedServer() != null && !this.serverConnManager.getConnectedServer().isConnected()) {
                LOGGER.logDebugMessage("server connection is down");
                return false;
            }
            if (!this.serverConnManager.shouldSendData()) {
                LOGGER.logDebugMessage("server does not allow to send data");
                return false;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logTraceMessage("Posting json to atc: " + jsonData);
            }
            PostOffice po = this.serverConnManager.getPostOffice();
            RemoteHttpCallClient client = new RemoteHttpCallClient(po, Configuration.geAtcHttpRequestTimeout());
            HashMap map = new HashMap();
            RemoteHttpResponse response = client.doPost(endPoint, jsonData, map);
            int responseCode = response.getHttpCode();
            LOGGER.logDebugMessage("Response code for ATC Post: " + responseCode);
            if (responseCode == 409) {
                LOGGER.logDebugMessage("Configuration/Graph is already stored in the database. No new changes detected");
                return true;
            }
            if (responseCode == 200) {
                this.atcPostFailed = false;
                this.atcPostLogCounter = 0;
                return true;
            }
            this.atcPostFailed = true;
            if (this.atcPostFailed && this.atcPostLogCounter == 0) {
                LOGGER.logError("Failed to POST " + jsonData + " to " + endPoint + ". Return code " + responseCode);
                LOGGER.logError(new String(response.getResponseBody(), "UTF8"));
                ++this.atcPostLogCounter;
            }
        }
        catch (Exception e) {
            if (!(e instanceof InterruptedException) && !(e.getCause() instanceof InterruptedException)) {
                LOGGER.logError("Failed to update ATC Map: " + e.getMessage());
            }
            LOGGER.logDebugMessage("Failed to update ATC Map", (Throwable)e);
        }
        return false;
    }

    public void generateAndSendATCData(Set<JmxNodeInfo> nodes) {
        if (!this.isConnectionUp()) {
            return;
        }
        LOGGER.logDebugMessage("Create and send jmx graph data");
        for (JmxNodeInfo node : nodes) {
            AtcJmxGraph graph = this.createGraph("JMX_SYSTEM");
            String ip = Utils.getIpAddr(node.getHost());
            String port = String.valueOf(node.getPort());
            String id = String.format("%s:%s:%s", node.getHostPort(), Constants.JMX_VERTEX_SOURCE_EXT, Configuration.getAgentName());
            AtcJmxVertex vertex = graph.createVertex(id);
            vertex.addAttribute("agent", Configuration.getAgentName());
            vertex.addAttribute("name", node.getAtcVertexInfo().getAtcVertexName());
            vertex.addAttribute("jmx_system_name", node.getSystemName());
            vertex.addAttribute("jmx_metrics_root", node.getMetricRoot());
            vertex.addAttribute("hostname", node.getHost());
            vertex.addAttribute("ipaddress", ip);
            vertex.addAttribute("jmx port", port);
            vertex.addAttribute("type", "JMX_SYSTEM");
            if (node.getAtcVertexInfo().getJmxCorId() != null) {
                vertex.addAttribute("jmxCorId", node.getAtcVertexInfo().getJmxCorId());
            }
            vertex.addAttribute("TTPlugin.correlation.proxy.1.source.host", node.getHost());
            vertex.addAttribute("TTPlugin.correlation.proxy.1.source.ip", ip);
            vertex.addAttribute("TTPlugin.correlation.proxy.1.source.port", port);
            vertex.addAttribute("TTPlugin.sourceID", "RemoteJmxClientExtension");
            graph.addVertex(vertex);
            graph.sendGraphtoAtc();
        }
    }

    public AtcJmxGraph createGraph(String type) {
        return new AtcJmxGraph(type);
    }

    public static final class AtcJmxVertex {
        private String key;
        private Vertex vertex;
        private Adler32 checksum;
        private HashMap<String, Object> properties = new HashMap();
        private long lastSent;

        public AtcJmxVertex(String key) {
            this.key = key;
            this.vertex = new Vertex();
            this.vertex.setAttributes(this.properties);
            this.vertex.setId(key);
            this.checksum = new Adler32();
            this.lastSent = System.currentTimeMillis();
        }

        public void addAttribute(String key, String value) {
            this.checksum.update(value.getBytes());
            this.properties.put(key, value);
        }

        public void addAttribute(String key, String[] values) {
            for (String value : values) {
                if (value == null) continue;
                this.checksum.update(value.getBytes());
            }
            this.properties.put(key, values);
        }

        public long getChecksum() {
            return this.checksum.getValue();
        }

        public String getKey() {
            return this.key;
        }

        public Vertex getVertex() {
            return this.vertex;
        }

        public long getLastSent() {
            return this.lastSent;
        }

        public void setLastSent(long now) {
            this.lastSent = now;
        }
    }

    public final class AtcJmxGraph {
        private Graph graph = new Graph();
        private HashMap<String, AtcJmxVertex> verticesToSend = new HashMap();
        private long now = System.currentTimeMillis();

        public AtcJmxGraph(String type) {
        }

        public AtcJmxVertex createVertex(String key) {
            return new AtcJmxVertex(key);
        }

        public void addVertex(AtcJmxVertex kafVertex) {
            String key = kafVertex.getKey();
            AtcJmxVertex entry = (AtcJmxVertex)AtcConnectionManager.this.updatedVertices.get(key);
            boolean doSend = false;
            if (entry == null) {
                doSend = true;
            } else if (entry.getChecksum() != kafVertex.getChecksum() || this.hasExpired(entry)) {
                doSend = true;
                LOGGER.logDebugMessage("removing outdated vertex: " + entry.getVertex());
                this.graph.removeVertexInfo(entry.getVertex());
            }
            if (doSend) {
                this.verticesToSend.put(key, kafVertex);
                this.graph.putVertexInfo(kafVertex.getVertex());
            }
        }

        public void sendGraphtoAtc() {
            if (this.verticesToSend.isEmpty()) {
                LOGGER.logDebugMessage("no updates in graph");
                return;
            }
            Gson gson = new Gson();
            ApmData data = new ApmData(this.graph, AtcConnectionManager.this.graphTtl);
            String jsonData = gson.toJson((Object)data);
            if (AtcConnectionManager.this.postATCData("/apm/appmap/ats/graph/store", jsonData)) {
                LOGGER.logDebugMessage("posted atc graph: " + jsonData);
                for (Map.Entry<String, AtcJmxVertex> entry : this.verticesToSend.entrySet()) {
                    AtcJmxVertex kafkaVertex = entry.getValue();
                    kafkaVertex.setLastSent(this.now);
                    AtcConnectionManager.this.updatedVertices.put(entry.getKey(), kafkaVertex);
                }
                this.verticesToSend.clear();
            }
            Iterator iterator = AtcConnectionManager.this.updatedVertices.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!this.hasExpired((AtcJmxVertex)iterator.next().getValue())) continue;
                iterator.remove();
            }
        }

        private boolean hasExpired(AtcJmxVertex vertex) {
            return vertex.lastSent + AtcConnectionManager.this.graphResendInterval < this.now;
        }
    }
}

