/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter;

import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class DynamicParamEntry {
    private final IModuleFeedbackChannel fFeedback;
    private final String paramName;
    private final boolean isLocal;
    private boolean referencesInvocationReturn = false;
    public static final String SpaceInsertionExpression = "(?:SPACEQQ)+";
    private IEvaluator finalEvaluator;
    private static final String CORR_ID_PLACE_HOLDER = "WILY_PLACE_HOLDER_FOR_CORR_ID";
    private static ThreadLocal realMethodsMap = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new HashMap();
        }
    };

    public static HashMap getRealMethodsMap() {
        return (HashMap)realMethodsMap.get();
    }

    public static Object getRealMethodsMapEntry(Object key) {
        return DynamicParamEntry.getRealMethodsMap().get(key);
    }

    public static Object putRealMethodsMapEntry(Object key, Object value) {
        return DynamicParamEntry.getRealMethodsMap().put(key, value);
    }

    public DynamicParamEntry(IModuleFeedbackChannel feedback, String paramString, LinkedList permittedLocalVariables, String ACTUAL_CORR_ID) throws Exception {
        IEvaluator currEvaluator;
        int i;
        this.fFeedback = feedback;
        int indexOfEquals = paramString.indexOf("=");
        if (indexOfEquals <= 0 || this.isEqualsPartOfEvaluatorOperator(paramString, indexOfEquals)) {
            throw new Exception("The DynamicParam entry: " + paramString + " does not contain a param name and param specification separated by: " + "=");
        }
        String paramName = paramString.substring(0, indexOfEquals);
        paramName = paramName.trim();
        String paramSpec = paramString.substring(indexOfEquals + "=".length());
        paramSpec = paramSpec.trim();
        this.paramName = paramName;
        this.isLocal = paramName.startsWith("Local_");
        if (this.paramName == null) {
            throw new Exception("Required field: DynamicParams not provided in DynamicParam entry.");
        }
        if (this.containsAdditionalEquals(paramSpec)) {
            throw new Exception("Possible missing ';' between DynamicParam entries. Conflicting part of syntax: " + paramString);
        }
        if (ACTUAL_CORR_ID != null) {
            if (WSMUtils.getLogger().isDebugEnabled()) {
                WSMUtils.getLogger().debug("paramSpec before replacing with correlation string: " + paramSpec + "[ACTUAL_CORR_ID: " + ACTUAL_CORR_ID + "]");
            }
            paramSpec = paramSpec.replaceAll(ACTUAL_CORR_ID, CORR_ID_PLACE_HOLDER);
            if (WSMUtils.getLogger().isDebugEnabled()) {
                WSMUtils.getLogger().debug("paramSpec after replacing with correlation string: " + paramSpec);
            }
        }
        boolean needsParsing = true;
        LinkedList<String> splitListByAndOrOperators = new LinkedList<String>();
        LinkedList<String> andOrOperators = new LinkedList<String>();
        while (needsParsing) {
            String firstToken;
            int indexOfAnd = paramSpec.toUpperCase().indexOf(" AND ");
            int indexOfOr = paramSpec.toUpperCase().indexOf(" OR ");
            if (indexOfAnd >= 0) {
                firstToken = paramSpec.substring(0, indexOfAnd);
                splitListByAndOrOperators.add(firstToken);
                andOrOperators.add(" AND ");
                paramSpec = paramSpec.substring(indexOfAnd + " AND ".length());
                continue;
            }
            if (indexOfOr >= 0) {
                firstToken = paramSpec.substring(0, indexOfOr);
                splitListByAndOrOperators.add(firstToken);
                andOrOperators.add(" OR ");
                paramSpec = paramSpec.substring(indexOfOr + " OR ".length());
                continue;
            }
            splitListByAndOrOperators.add(paramSpec);
            needsParsing = false;
        }
        LinkedList<IEvaluator> evaluators = new LinkedList<IEvaluator>();
        for (i = 0; i < splitListByAndOrOperators.size(); ++i) {
            String currStr = (String)splitListByAndOrOperators.get(i);
            currEvaluator = this.createEvaluator(currStr, permittedLocalVariables, ACTUAL_CORR_ID);
            evaluators.add(currEvaluator);
        }
        this.finalEvaluator = (IEvaluator)evaluators.remove(0);
        for (i = 0; i < andOrOperators.size(); ++i) {
            String currOperator = (String)andOrOperators.get(i);
            currEvaluator = (IEvaluator)evaluators.remove(0);
            if (currOperator.equalsIgnoreCase(" AND ")) {
                this.finalEvaluator = new AndOperatorEvaluator(this.finalEvaluator, currEvaluator);
                continue;
            }
            if (!currOperator.equalsIgnoreCase(" OR ")) continue;
            this.finalEvaluator = new OrOperatorEvaluator(this.finalEvaluator, currEvaluator);
        }
    }

    private boolean containsAdditionalEquals(String paramSpec) {
        int equalIndex = paramSpec.indexOf("=");
        if (equalIndex != -1) {
            if (this.isEqualsPartOfEvaluatorOperator(paramSpec, equalIndex)) {
                if (this.containsAdditionalEquals(paramSpec.substring(equalIndex + 2))) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean isEqualsPartOfEvaluatorOperator(String paramSpec, int equalIndex) {
        int eeIndex = paramSpec.indexOf("==");
        int neIndex = paramSpec.indexOf("!=");
        int ltIndex = paramSpec.indexOf("<");
        int gtIndex = paramSpec.indexOf(">");
        return equalIndex == eeIndex || equalIndex == neIndex + 1 || equalIndex == ltIndex + 1 || equalIndex == gtIndex + 1;
    }

    public boolean getIsLocal() {
        return this.isLocal;
    }

    public String getParamName() {
        return this.paramName;
    }

    public boolean isInvocationReturnReferenced() {
        return this.referencesInvocationReturn;
    }

    public Object getValue(HashMap localInvVariables) throws Exception {
        return this.finalEvaluator.getValue(localInvVariables);
    }

    public String toString() {
        return this.paramName + "=" + this.finalEvaluator;
    }

    private IEvaluator createEvaluator(String paramObjsSpec, LinkedList permittedLocalVariables, String ACTUAL_CORR_ID) throws Exception {
        IEvaluator evaluator = null;
        if (paramObjsSpec.indexOf("==") > 0) {
            int indexOfOperator = paramObjsSpec.indexOf("==");
            IEvaluator evalWith = this.createObjectEvaluator(paramObjsSpec.substring(0, indexOfOperator), permittedLocalVariables, ACTUAL_CORR_ID);
            IEvaluator evalTo = this.createObjectEvaluator(paramObjsSpec.substring(indexOfOperator + "==".length()), permittedLocalVariables, ACTUAL_CORR_ID);
            evaluator = new EqualsOperatorEvaluator(evalWith, evalTo);
        } else if (paramObjsSpec.indexOf("<=") > 0) {
            int indexOfOperator = paramObjsSpec.indexOf("<=");
            IEvaluator evalWith = this.createObjectEvaluator(paramObjsSpec.substring(0, indexOfOperator), permittedLocalVariables, ACTUAL_CORR_ID);
            IEvaluator evalTo = this.createObjectEvaluator(paramObjsSpec.substring(indexOfOperator + "<=".length()), permittedLocalVariables, ACTUAL_CORR_ID);
            evaluator = new LessThanEqualToOperatorEvaluator(evalWith, evalTo);
        } else if (paramObjsSpec.indexOf("<") > 0) {
            int indexOfOperator = paramObjsSpec.indexOf("<");
            IEvaluator evalWith = this.createObjectEvaluator(paramObjsSpec.substring(0, indexOfOperator), permittedLocalVariables, ACTUAL_CORR_ID);
            IEvaluator evalTo = this.createObjectEvaluator(paramObjsSpec.substring(indexOfOperator + "<".length()), permittedLocalVariables, ACTUAL_CORR_ID);
            evaluator = new LessThanOperatorEvaluator(evalWith, evalTo);
        } else if (paramObjsSpec.indexOf(">=") > 0) {
            int indexOfOperator = paramObjsSpec.indexOf(">=");
            IEvaluator evalWith = this.createObjectEvaluator(paramObjsSpec.substring(0, indexOfOperator), permittedLocalVariables, ACTUAL_CORR_ID);
            IEvaluator evalTo = this.createObjectEvaluator(paramObjsSpec.substring(indexOfOperator + ">=".length()), permittedLocalVariables, ACTUAL_CORR_ID);
            evaluator = new GreaterThanEqualToOperatorEvaluator(evalWith, evalTo);
        } else if (paramObjsSpec.indexOf(">") > 0) {
            int indexOfOperator = paramObjsSpec.indexOf(">");
            IEvaluator evalWith = this.createObjectEvaluator(paramObjsSpec.substring(0, indexOfOperator), permittedLocalVariables, ACTUAL_CORR_ID);
            IEvaluator evalTo = this.createObjectEvaluator(paramObjsSpec.substring(indexOfOperator + ">".length()), permittedLocalVariables, ACTUAL_CORR_ID);
            evaluator = new GreaterThanOperatorEvaluator(evalWith, evalTo);
        } else if (paramObjsSpec.indexOf("!=") > 0) {
            int indexOfOperator = paramObjsSpec.indexOf("!=");
            IEvaluator evalWith = this.createObjectEvaluator(paramObjsSpec.substring(0, indexOfOperator), permittedLocalVariables, ACTUAL_CORR_ID);
            IEvaluator evalTo = this.createObjectEvaluator(paramObjsSpec.substring(indexOfOperator + "!=".length()), permittedLocalVariables, ACTUAL_CORR_ID);
            evaluator = new NotEqualsOperatorEvaluator(evalWith, evalTo);
        } else {
            evaluator = this.createObjectEvaluator(paramObjsSpec.trim(), permittedLocalVariables, ACTUAL_CORR_ID);
        }
        return evaluator;
    }

    private IEvaluator createObjectEvaluator(String paramObjSpec, LinkedList permittedLocalVariables, String ACTUAL_CORR_ID) throws Exception {
        int indexOfMethodParamStart = (paramObjSpec = paramObjSpec.trim()).indexOf("(");
        if (indexOfMethodParamStart > 0) {
            int indexOfDot = paramObjSpec.indexOf(".");
            String localObjName = paramObjSpec.substring(0, indexOfDot).trim();
            if (localObjName == null || localObjName.length() == 0) {
                throw new Exception("No java object specified to invoke methods on provided in the DynamicParam entry: " + paramObjSpec);
            }
            if (localObjName.equalsIgnoreCase("InvocationReturn")) {
                this.referencesInvocationReturn = true;
            }
            ObjectMethodsEvaluator evaluator = new ObjectMethodsEvaluator(localObjName);
            String methodsAndEvalSpec = paramObjSpec.substring(indexOfDot + 1).trim();
            this.addParamMethods(methodsAndEvalSpec, evaluator, ACTUAL_CORR_ID);
            if (evaluator.getNumMethods() == 0) {
                throw new Exception("No java methods specified to executed on object: " + localObjName + " in DynamicParam entry: " + paramObjSpec);
            }
            return evaluator;
        }
        int indexOfMethodParamFinish = paramObjSpec.indexOf(")");
        if (indexOfMethodParamFinish > 0) {
            throw new Exception("'(' is missing in DynamicParam entry: " + paramObjSpec);
        }
        PresetValueEvaluator evaluator = new PresetValueEvaluator(paramObjSpec);
        return evaluator;
    }

    private void addParamMethods(String methodsSpec, ObjectMethodsEvaluator paramObject, String ACTUAL_CORR_ID) throws Exception {
        boolean hasMoreMethods = true;
        while (hasMoreMethods) {
            ParamMethod paramMethod = new ParamMethod();
            int indexOfMethodParamBegin = methodsSpec.indexOf("(");
            if (indexOfMethodParamBegin == -1) {
                throw new Exception("'(' is missing.");
            }
            String methodName = methodsSpec.substring(0, indexOfMethodParamBegin).trim();
            if (methodName.length() == 0) {
                throw new Exception("Method to invoke not provided in DynamicParam entry.");
            }
            paramMethod.setMethodName(methodName);
            int indexOfMethodParamEnd = methodsSpec.indexOf(")");
            if (indexOfMethodParamEnd == -1) {
                throw new Exception("')' is missing.");
            }
            if (indexOfMethodParamEnd - indexOfMethodParamBegin > 1) {
                String methodParamsSpec = methodsSpec.substring(indexOfMethodParamBegin + 1, indexOfMethodParamEnd).trim();
                WSMUtils.refreshLogLevels();
                StringTokenizer methodParams = new StringTokenizer(methodParamsSpec);
                if (WSMUtils.getLogger().isDebugEnabled()) {
                    WSMUtils.getLogger().debug("ACTUAL_CORR_ID: " + ACTUAL_CORR_ID);
                    WSMUtils.getLogger().debug("DynamicParam entry: methodsSpec.substring(indexOfMethodParamBegin + 1, indexOfMethodParamEnd=" + methodsSpec.substring(indexOfMethodParamBegin + 1, indexOfMethodParamEnd));
                    WSMUtils.getLogger().debug("DynamicParam entry: methodParamsSpec=" + methodParamsSpec);
                    int tokens = methodParams.countTokens();
                    for (int i = 0; i < tokens; ++i) {
                        WSMUtils.getLogger().debug("DynamicParam entry: methodParams.nextToken()=" + methodParams.nextToken());
                    }
                    methodParams = new StringTokenizer(methodParamsSpec);
                }
                if (methodParams.countTokens() % 2 != 0) {
                    throw new Exception("DynamicParam entry: " + methodParamsSpec + " contains an odd number of method parameters. Params need to be in (javaType value) pairs.");
                }
                int numParams = methodParams.countTokens() / 2;
                Class[] paramTypes = new Class[numParams];
                Object[] paramValues = new Object[numParams];
                for (int i = 0; i < numParams; ++i) {
                    paramTypes[i] = this.getMethodParamClass(methodParams.nextToken());
                    String paramValue = methodParams.nextToken();
                    paramValue = paramValue.replaceAll(SpaceInsertionExpression, " ");
                    if (WSMUtils.getLogger().isDebugEnabled()) {
                        WSMUtils.getLogger().debug("DynamicParamEntry addParamMethods: paramValue=" + paramValue);
                    }
                    if (paramValue.equals("Local_EMPTY_STRING")) {
                        paramValues[i] = "";
                        continue;
                    }
                    if (paramValues.equals(CORR_ID_PLACE_HOLDER)) {
                        paramValues[i] = ACTUAL_CORR_ID.replaceAll(SpaceInsertionExpression, " ");
                        if (!WSMUtils.getLogger().isDebugEnabled()) continue;
                        WSMUtils.getLogger().debug("found the parameter as correlation string: " + ACTUAL_CORR_ID);
                        continue;
                    }
                    paramValues[i] = paramValue;
                }
                paramMethod.setMethodParamTypes(paramTypes);
                paramMethod.setMethodParamValues(paramValues);
            }
            paramObject.addMethod(paramMethod);
            methodsSpec = methodsSpec.substring(indexOfMethodParamEnd).trim();
            if (methodsSpec.length() > 1) {
                if (!(methodsSpec = methodsSpec.substring(1).trim()).startsWith(".")) {
                    throw new Exception("Java Method calls in the DynamicParam entry need to be separated by dot");
                }
                methodsSpec = methodsSpec.substring(1).trim();
                hasMoreMethods = true;
                continue;
            }
            hasMoreMethods = false;
        }
    }

    private Class getMethodParamClass(String paramType) throws Exception {
        return Class.forName(paramType);
    }

    private static class ParamMethod {
        private String methodName;
        private Class[] methodParamTypes;
        private Object[] methodParamValues;

        private ParamMethod() {
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public void setMethodParamTypes(Class[] methodParamTypes) {
            this.methodParamTypes = methodParamTypes;
        }

        public void setMethodParamValues(Object[] methodParamValues) {
            this.methodParamValues = methodParamValues;
        }

        private void processParamValues(Object[] methodParamValues, HashMap localInvVariables) {
            if (methodParamValues != null) {
                for (int i = 0; i < methodParamValues.length; ++i) {
                    if (!methodParamValues[i].toString().startsWith("Local_")) continue;
                    Object localVar = localInvVariables.get(methodParamValues[i]);
                    methodParamValues[i] = localVar;
                }
            }
        }

        public Object invoke(Object invokeObject, HashMap localInvVariables) throws Exception {
            Method realMethod;
            if (invokeObject == null) {
                throw new Exception("Null object in method invocation: " + this.methodName);
            }
            Class invokeClass = invokeObject.getClass();
            if (invokeObject.getClass().getName().equals("java.lang.Class")) {
                invokeClass = (Class)invokeObject;
            }
            String invokeClassName = invokeClass.getName();
            WSMUtils.refreshLogLevels();
            if (WSMUtils.getLogger().isDebugEnabled()) {
                WSMUtils.getLogger().debug(" class=" + invokeClass.getName());
            }
            if ((realMethod = (Method)DynamicParamEntry.getRealMethodsMapEntry(invokeClassName + this.methodName)) == null) {
                WSMUtils.getLogger().debug("Method not found in cache");
                realMethod = this.findExecutableMethod(invokeClass);
                realMethod.setAccessible(true);
                DynamicParamEntry.putRealMethodsMapEntry(invokeClassName + this.methodName, realMethod);
            } else {
                WSMUtils.getLogger().debug("Method found in cache");
            }
            this.processParamValues(this.methodParamValues, localInvVariables);
            if (WSMUtils.getLogger().isDebugEnabled()) {
                WSMUtils.getLogger().debug("realMethod=" + realMethod.getName() + " realMethod.getReturnType()=" + realMethod.getReturnType() + " class=" + invokeClass.getName());
                if (this.methodParamValues != null) {
                    for (int i = 0; i < this.methodParamValues.length; ++i) {
                        WSMUtils.getLogger().debug("this.methodParamValues[i].toString()" + this.methodParamValues[i].toString());
                    }
                }
            }
            Object retObject = realMethod.invoke(invokeObject, this.methodParamValues);
            WSMUtils.getLogger().debug("invoke retObject =" + retObject);
            if (retObject != null && retObject.getClass().isArray()) {
                if (((Object[])retObject).length == 0) {
                    retObject = null;
                } else {
                    retObject = ((Object[])retObject)[0];
                    WSMUtils.getLogger().debug("invoke retObject[0] =" + retObject);
                }
            }
            if (retObject == null) {
                retObject = "";
            }
            return retObject;
        }

        /*
         * Unable to fully structure code
         */
        private Method findExecutableMethod(Class invokeClass) throws Exception {
            realMethod = this.getNonPkgProtectedMethod(invokeClass);
            if (realMethod == null) {
                ifaces = invokeClass.getInterfaces();
                for (i = 0; i < ifaces.length; ++i) {
                    try {
                        realMethod = this.getNonPkgProtectedMethod(ifaces[i]);
                        if (realMethod == null) continue;
                        break;
                    }
                    catch (SecurityException var5_7) {
                        continue;
                    }
                    catch (NoSuchMethodException var5_8) {
                        // empty catch block
                    }
                }
                ** if (realMethod != null) goto lbl25
                for (superClass = invokeClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                    try {
                        realMethod = this.getNonPkgProtectedMethod(superClass);
                    }
                    catch (SecurityException var5_9) {
                    }
                    catch (NoSuchMethodException var5_10) {
                        // empty catch block
                    }
                    if (realMethod != null) break;
lbl-1000:
                    // 2 sources

                    {
                        continue;
                    }
                }
            }
lbl25:
            // 5 sources

            if (realMethod == null) {
                throw new Exception("Could not find method: " + this.methodName + " with public executable scope in class " + invokeClass.getName() + " or its interfaces or super classes.");
            }
            return realMethod;
        }

        private Method getNonPkgProtectedMethod(Class currClass) throws Exception {
            try {
                Method realMethod = currClass.getDeclaredMethod(this.methodName, this.methodParamTypes);
                return realMethod;
            }
            catch (Exception e) {
                WSMUtils.getLogger().debug("getNonPkgProtectedMethod Could not find method: " + this.methodName + " in class " + currClass + " using getDeclaredMethod");
                try {
                    Method realMethod = currClass.getMethod(this.methodName, this.methodParamTypes);
                    return realMethod;
                }
                catch (Exception e2) {
                    throw new Exception("getNonPkgProtectedMethod Could not find method: " + this.methodName + " in class " + currClass);
                }
            }
        }

        private boolean isPackageProtected(int modifier) {
            return !Modifier.isPublic(modifier) && !Modifier.isPrivate(modifier) && !Modifier.isProtected(modifier);
        }

        public String toString() {
            String str = this.methodName + "(";
            if (this.methodParamValues != null && this.methodParamValues.length > 0) {
                for (int i = 0; i < this.methodParamValues.length; ++i) {
                    WSMUtils.getLogger().debug("methodParamValues[i]=" + this.methodParamValues[i]);
                    if (this.methodParamValues[i] == null) continue;
                    str = str + this.methodParamValues[i].toString() + ", ";
                }
                str = str.substring(0, str.length() - 2);
            }
            str = str + ")";
            return str;
        }
    }

    private static class OrOperatorEvaluator
    extends OperatorEvaluator {
        public OrOperatorEvaluator(IEvaluator evalWith, IEvaluator evalTo) {
            super(evalWith, evalTo);
        }

        @Override
        protected String getOperator() {
            return " OR ";
        }

        @Override
        protected boolean eval(HashMap localInvVariables) throws Exception {
            boolean inBooleanVal = new Boolean(this.evalWith.getValue(localInvVariables).toString());
            if (inBooleanVal) {
                return inBooleanVal;
            }
            boolean evalToBooleanVal = new Boolean(this.evalTo.getValue(localInvVariables).toString());
            return inBooleanVal || evalToBooleanVal;
        }

        @Override
        public String toString() {
            return "(" + this.evalWith + " OR " + this.evalTo + ")";
        }
    }

    private static class AndOperatorEvaluator
    extends OperatorEvaluator {
        public AndOperatorEvaluator(IEvaluator evalWith, IEvaluator evalTo) {
            super(evalWith, evalTo);
        }

        @Override
        protected String getOperator() {
            return " AND ";
        }

        @Override
        protected boolean eval(HashMap localInvVariables) throws Exception {
            boolean inBooleanVal = new Boolean(this.evalWith.getValue(localInvVariables).toString());
            if (!inBooleanVal) {
                return inBooleanVal;
            }
            boolean evalToBooleanVal = new Boolean(this.evalTo.getValue(localInvVariables).toString());
            return inBooleanVal && evalToBooleanVal;
        }

        @Override
        public String toString() {
            return "(" + this.evalWith + " AND " + this.evalTo + ")";
        }
    }

    private static class GreaterThanOperatorEvaluator
    extends OperatorEvaluator {
        public GreaterThanOperatorEvaluator(IEvaluator evalWith, IEvaluator evalTo) {
            super(evalWith, evalTo);
        }

        @Override
        protected String getOperator() {
            return ">";
        }

        @Override
        protected boolean eval(HashMap localInvVariables) throws Exception {
            double evalToDoubleVal;
            double inDoubleVal = new Double(this.evalWith.getValue(localInvVariables).toString());
            return inDoubleVal > (evalToDoubleVal = new Double(this.evalTo.getValue(localInvVariables).toString()).doubleValue());
        }
    }

    private static class GreaterThanEqualToOperatorEvaluator
    extends OperatorEvaluator {
        public GreaterThanEqualToOperatorEvaluator(IEvaluator evalWith, IEvaluator evalTo) {
            super(evalWith, evalTo);
        }

        @Override
        protected String getOperator() {
            return ">=";
        }

        @Override
        protected boolean eval(HashMap localInvVariables) throws Exception {
            double evalToDoubleVal;
            double inDoubleVal = new Double(this.evalWith.getValue(localInvVariables).toString());
            return inDoubleVal >= (evalToDoubleVal = new Double(this.evalTo.getValue(localInvVariables).toString()).doubleValue());
        }
    }

    private static class LessThanOperatorEvaluator
    extends OperatorEvaluator {
        public LessThanOperatorEvaluator(IEvaluator evalWith, IEvaluator evalTo) {
            super(evalWith, evalTo);
        }

        @Override
        protected String getOperator() {
            return "<";
        }

        @Override
        protected boolean eval(HashMap localInvVariables) throws Exception {
            double evalToDoubleVal;
            double inDoubleVal = new Double(this.evalWith.getValue(localInvVariables).toString());
            return inDoubleVal < (evalToDoubleVal = new Double(this.evalTo.getValue(localInvVariables).toString()).doubleValue());
        }
    }

    private static class LessThanEqualToOperatorEvaluator
    extends OperatorEvaluator {
        public LessThanEqualToOperatorEvaluator(IEvaluator evalWith, IEvaluator evalTo) {
            super(evalWith, evalTo);
        }

        @Override
        protected String getOperator() {
            return "<=";
        }

        @Override
        protected boolean eval(HashMap localInvVariables) throws Exception {
            double evalToDoubleVal;
            double inDoubleVal = new Double(this.evalWith.getValue(localInvVariables).toString());
            return inDoubleVal <= (evalToDoubleVal = new Double(this.evalTo.getValue(localInvVariables).toString()).doubleValue());
        }
    }

    private static class NotEqualsOperatorEvaluator
    extends OperatorEvaluator {
        public NotEqualsOperatorEvaluator(IEvaluator evalWith, IEvaluator evalTo) {
            super(evalWith, evalTo);
        }

        @Override
        protected String getOperator() {
            return "!=";
        }

        @Override
        protected boolean eval(HashMap localInvVariables) throws Exception {
            Object evalWithObj = this.evalWith.getValue(localInvVariables);
            Object evalToObj = this.evalTo.getValue(localInvVariables);
            if (evalToObj.toString().equalsIgnoreCase("null")) {
                return evalWithObj != null;
            }
            if (evalToObj.toString().equalsIgnoreCase("true")) {
                boolean inBooleanVal = new Boolean(evalWithObj.toString());
                return !inBooleanVal;
            }
            if (evalToObj.toString().equalsIgnoreCase("false")) {
                boolean inBooleanVal = new Boolean(evalWithObj.toString());
                return inBooleanVal;
            }
            try {
                double inDoubleVal = new Double(evalWithObj.toString());
                double evalToDoubleVal = new Double(evalToObj.toString());
                return inDoubleVal != evalToDoubleVal;
            }
            catch (NumberFormatException nbfe) {
                return !evalWithObj.equals(evalToObj);
            }
        }
    }

    private static class EqualsOperatorEvaluator
    extends OperatorEvaluator {
        public EqualsOperatorEvaluator(IEvaluator evalWith, IEvaluator evalTo) {
            super(evalWith, evalTo);
        }

        @Override
        protected String getOperator() {
            return "==";
        }

        @Override
        protected boolean eval(HashMap localInvVariables) throws Exception {
            Object evalWithObj = this.evalWith.getValue(localInvVariables);
            Object evalToObj = this.evalTo.getValue(localInvVariables);
            if (evalToObj.toString().equalsIgnoreCase("null")) {
                return evalWithObj == null;
            }
            if (evalToObj.toString().equalsIgnoreCase("true")) {
                boolean inBooleanVal = new Boolean(evalWithObj.toString());
                return inBooleanVal;
            }
            if (evalToObj.toString().equalsIgnoreCase("false")) {
                boolean inBooleanVal = new Boolean(evalWithObj.toString());
                return !inBooleanVal;
            }
            try {
                double inDoubleVal = new Double(evalWithObj.toString());
                double evalToDoubleVal = new Double(evalToObj.toString());
                return inDoubleVal == evalToDoubleVal;
            }
            catch (NumberFormatException nfe) {
                return evalWithObj.equals(evalToObj);
            }
        }
    }

    private static abstract class OperatorEvaluator
    implements IEvaluator {
        protected IEvaluator evalWith = null;
        protected IEvaluator evalTo = null;

        public OperatorEvaluator(IEvaluator evalWith, IEvaluator evalTo) {
            this.evalWith = evalWith;
            this.evalTo = evalTo;
        }

        @Override
        public Object getValue(HashMap localInvVariables) throws Exception {
            Boolean retObject = this.eval(localInvVariables);
            return retObject;
        }

        public void validate() throws Exception {
            if (this.evalWith == null) {
                throw new Exception("No java object specified to invoke methods on in the DynamicParam entry.");
            }
        }

        protected abstract String getOperator();

        protected abstract boolean eval(HashMap var1) throws Exception;

        public String toString() {
            return this.evalWith + " " + this.getOperator() + " " + this.evalTo;
        }
    }

    private class ObjectMethodsEvaluator
    implements IEvaluator {
        private String localObjectName;
        private ParamMethod[] paramMethods = new ParamMethod[0];

        public ObjectMethodsEvaluator(String localObjectName) {
            this.localObjectName = localObjectName;
        }

        public void addMethod(ParamMethod paramMethod) {
            ParamMethod[] paramMethodsTmp = new ParamMethod[this.paramMethods.length + 1];
            int i = 0;
            for (i = 0; i < this.paramMethods.length; ++i) {
                paramMethodsTmp[i] = this.paramMethods[i];
            }
            paramMethodsTmp[i] = paramMethod;
            this.paramMethods = paramMethodsTmp;
        }

        public int getNumMethods() {
            return this.paramMethods.length;
        }

        @Override
        public Object getValue(HashMap localInvVariables) throws Exception {
            Object retObject = null;
            if (this.paramMethods.length > 0) {
                Object currInvObject = localInvVariables.get(this.localObjectName);
                if (currInvObject == null) {
                    DynamicParamEntry.this.fFeedback.debug("Cannot execute: " + this.toString() + ". Null object for local dynamic param: " + this.localObjectName);
                    return "";
                }
                for (int i = 0; i < this.paramMethods.length; ++i) {
                    ParamMethod currParamMethod = this.paramMethods[i];
                    retObject = currParamMethod.invoke(currInvObject, localInvVariables);
                    currInvObject = retObject;
                }
            }
            return retObject;
        }

        public String toString() {
            String objMethods = this.localObjectName + ".";
            int i = 0;
            for (i = 0; i < this.paramMethods.length - 1; ++i) {
                objMethods = objMethods + this.paramMethods[i] + ".";
            }
            objMethods = objMethods + this.paramMethods[i];
            return objMethods;
        }
    }

    private class PresetValueEvaluator
    implements IEvaluator {
        private String presetValue = null;

        public PresetValueEvaluator(String presetValue) throws Exception {
            this.presetValue = presetValue;
            if (presetValue.equalsIgnoreCase("InvocationReturn")) {
                DynamicParamEntry.this.referencesInvocationReturn = true;
            }
        }

        @Override
        public Object getValue(HashMap localInvVariables) throws Exception {
            if (!localInvVariables.containsKey(this.presetValue)) {
                return this.presetValue;
            }
            Object presetObjInMap = localInvVariables.get(this.presetValue);
            return presetObjInMap;
        }

        public String toString() {
            return this.presetValue;
        }
    }

    private static interface IEvaluator {
        public Object getValue(HashMap var1) throws Exception;
    }
}

