/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.websphere;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class ClientAsyncResponseTimeTracer
extends ASingleInstanceTracerFactory
implements KConstants {
    private String CEventType = "Normal";
    private static final String kMetricNameDivider = ":";
    private static final String kResponseTimeMetricDefault = "Average Response Time (ms)";
    private static final String kPerIntervalMetricDefault = "Responses Per Interval";
    private static final String kErrorMetricDefault = "Errors Per Interval";
    protected final IModuleFeedbackChannel logger;
    private DataAccumulatorFactory factory;

    public ClientAsyncResponseTimeTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_finishTrace(int i, InvocationData data) {
        ILongIntervalCounterDataAccumulator accumIntervalCnt;
        this.logger.debug("ClientAsyncResponseTimeTracer:Entered ClientAsynchTracer finish trace");
        long stoptime = System.currentTimeMillis();
        long starttime = 0L;
        long crestime = 0L;
        try {
            Object listenerObj = data.getInvocationObject();
            Object handlerObj = WSMUtils.invokeMethodOnObject(listenerObj, "getHandler");
            Map reqctxtobj = (Map)WSMUtils.invokeMethodOnObject(handlerObj, "getRequestContext");
            starttime = (Long)reqctxtobj.get("soa_asynch_client");
        }
        catch (Throwable e) {
            this.logger.info("ClientAsynchResponseTimeTracer:Error in retreiving from request context", e);
        }
        crestime = stoptime - starttime;
        int avgrestime = (int)crestime;
        this.logger.debug("ClientAsyncResponseTimeTracer:crestime" + crestime);
        String component = this.formatParameterizedName(data);
        BlameStackSnapshot snap = this.getComponentTracer().getSnapshot(component);
        this.logger.debug("ClientAsyncResponseTimeTracer:component" + component);
        this.factory = this.getAgent().IAgent_getDataAccumulatorFactory();
        IIntegerAverageDataAccumulator accumRespTime = this.factory.safeGetIntegerAverageDataAccumulator(component + kMetricNameDivider + kResponseTimeMetricDefault);
        if (!accumRespTime.IDataAccumulator_isShutOff()) {
            accumRespTime.IIntegerAggregatingDataAccumulator_recordDataPoint(avgrestime);
        }
        if (!(accumIntervalCnt = this.factory.safeGetLongIntervalCounterDataAccumulator(component + kMetricNameDivider + kPerIntervalMetricDefault)).IDataAccumulator_isShutOff()) {
            accumIntervalCnt.ILongIntervalCounterDataAccumulator_addSingleIncident();
        }
        ILongIntervalCounterDataAccumulator accumErrorCnt = this.factory.safeGetLongIntervalCounterDataAccumulator(component + kMetricNameDivider + kErrorMetricDefault);
        accumErrorCnt.forceMetricToExist(snap);
    }

    public void ITracer_startTrace(int i, InvocationData invocationdata) {
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

