/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.formatter.producer;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.formatter.producer.AFormatter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;

public class WLS9Formatter
extends AFormatter {
    public WLS9Formatter(IAgent agent) {
        super(agent);
    }

    @Override
    public String getServiceName(InvocationData data) {
        String name = null;
        try {
            Object context = this.getMessageContext(data);
            if (context != null) {
                Class<?> cl = context.getClass();
                Method getProperty = WSMUtils.findGetPropertyWithStringArgMethod(cl);
                Object value = getProperty.invoke(context, "weblogic.wsee.addressing.To");
                String valueString = WSMUtils.toString(value);
                name = WSMUtils.formatURLToBeResourceSafe(valueString);
            }
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Service_Name", t);
        }
        return name == null ? "UnknownService" : name;
    }

    @Override
    public String getOperation(InvocationData data) {
        String operation = null;
        try {
            Object context = this.getMessageContext(data);
            if (context != null) {
                Class<?> cl = context.getClass();
                Method getProperty = WSMUtils.findGetPropertyWithStringArgMethod(cl);
                Object value = getProperty.invoke(context, "weblogic.wsee.ws.server.OperationName");
                operation = (String)WSMUtils.invokeMethodOnObject(value, "getLocalPart");
            }
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Operation_Name", t);
        }
        return operation == null ? "UnknownOperationName" : operation;
    }

    @Override
    protected Object getMessageContext(InvocationData data) {
        try {
            Object context = data.getInvocationParameterAsObject(0);
            return context;
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Retrieving_Message_Context", t);
            return null;
        }
    }

    @Override
    protected void debug(InvocationData data) throws NoSuchMethodException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, AgentNotAvailableException {
        Object o = this.getMessageContext(data);
        if (o != null) {
            Thread.dumpStack();
            Class<?> cl = o.getClass();
            Iterator i = (Iterator)WSMUtils.invokeMethodOnObject(o, "getPropertyNames");
            while (i.hasNext()) {
                Object key = i.next();
                String keyString = WSMUtils.toString(key);
                Method getProperty = WSMUtils.findGetPropertyWithStringArgMethod(cl);
                Object value = getProperty.invoke(o, key);
                String valueString = WSMUtils.toString(value);
                AgentShim.getAgent().IAgent_getModuleFeedback().info("Key: " + keyString + "::: Value " + valueString);
            }
        }
    }
}

