/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.trace.weblogic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.trace.weblogic.WLS8ProducerFaultTracer;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;

public class WLS10ProducerFaultTracer
extends WLS8ProducerFaultTracer {
    public WLS10ProducerFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected boolean reportFaultIfExists(InvocationData data) {
        boolean faultExists = false;
        try {
            Object dispatcher = data.getInvocationObject();
            Class<?> dispatcherClass = dispatcher.getClass();
            Object packet = data.getInvocationParameterAsObject(0);
            Object message = WSMUtils.invokeMethodOnObject(packet, "getMessage");
            Class<?> messageClass = message.getClass().getSuperclass().getSuperclass();
            Method isFault = messageClass.getMethod("isFault", null);
            Boolean hasFault = (Boolean)isFault.invoke(message, null);
            if (hasFault.booleanValue()) {
                Object fault = WSMUtils.invokeMethodOnObject(message, "getFaultString");
                this.reportFault(fault.toString(), data);
                faultExists = true;
            }
            if (!faultExists && data.hasInvocationThrownException()) {
                this.reportFault(data.getInvocationThrownException().getMessage(), data);
                faultExists = true;
            }
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Retrieving_Message_Fault", t);
        }
        return faultExists;
    }
}

