/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.apmservices.client.httpclient;

import com.wily.introscope.agent.apmservices.client.sustainability.SustainabilityMetricReporter;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HttpClientFactory {
    private HttpClientFactory() {
    }

    private static OkHttpClient getHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(30L, TimeUnit.SECONDS);
        builder.readTimeout(120L, TimeUnit.SECONDS);
        builder.writeTimeout(120L, TimeUnit.SECONDS);
        try {
            TrustManager[] trustAllCerts = HttpClientFactory.getTrustManagers();
            SSLSocketFactory sslSocketFactory = HttpClientFactory.getSslSocketFactory(trustAllCerts);
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder.build();
    }

    private static SSLSocketFactory getSslSocketFactory(TrustManager[] trustAllCerts) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        return sslContext.getSocketFactory();
    }

    private static TrustManager[] getTrustManagers() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        return trustAllCerts;
    }

    public static void executeRequestAsync(Request httpReq, Callback asyncCompletionHandler) {
        long starTime = System.currentTimeMillis();
        HTTPClientInstance.httpClient.newCall(httpReq).enqueue(asyncCompletionHandler);
        long totalTime = System.currentTimeMillis() - starTime;
        SustainabilityMetricReporter.reportLongCounter("Agent Stats|Sustainability|APM Services Client|NASS|HTTP Client:Requests Enqueue Time(ms)", totalTime);
    }

    public static Response executeRequestSync(Request httpReq) throws IOException {
        long starTime = System.currentTimeMillis();
        Response result = HTTPClientInstance.httpClient.newCall(httpReq).execute();
        long totalTime = System.currentTimeMillis() - starTime;
        SustainabilityMetricReporter.reportLongCounter("Agent Stats|Sustainability|APM Services Client|NASS|HTTP Client:Requests Enqueue Time(ms)", totalTime);
        return result;
    }

    static /* synthetic */ OkHttpClient access$000() {
        return HttpClientFactory.getHttpClient();
    }

    private static class HTTPClientInstance {
        private static final OkHttpClient httpClient = HttpClientFactory.access$000();

        private HTTPClientInstance() {
        }
    }
}

