/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.directives.utility.CompilerSettingsUtility;
import com.wily.diagnos.personality.java.classfile.constants.DGClassConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DGInterfaces {
    private DGConstantPool fConstantPool;
    private int[] fCPI_interfaces;
    private final String[] fCachedInterfaces;
    private final String[] fPossibleKeys;

    public DGInterfaces(DGConstantPool constantPool, DataInputStream in) throws IOException {
        this.fConstantPool = constantPool;
        int count = in.readUnsignedShort();
        this.fCPI_interfaces = new int[count];
        this.fCachedInterfaces = new String[count];
        String[] fetchedKeys = new String[count];
        boolean succeded = true;
        for (int i = 0; i < count; ++i) {
            this.fCPI_interfaces[i] = in.readUnsignedShort();
            DGClassConstant impl = (DGClassConstant)this.fConstantPool.getConstant(this.fCPI_interfaces[i]);
            this.fCachedInterfaces[i] = impl.getClassNameString();
            try {
                fetchedKeys[i] = CompilerSettingsUtility.getKeyFromString(ClassName.getClassName((String)this.fCachedInterfaces[i]).getPackageAndNameString());
                continue;
            }
            catch (InvalidClassNameException e) {
                succeded = false;
                break;
            }
        }
        this.fPossibleKeys = !succeded ? null : fetchedKeys;
    }

    public DGInterfaces(DGConstantPool constantPool, String[] interfaces) throws DGClassModificationException {
        this.fConstantPool = constantPool;
        if (interfaces == null) {
            this.fCPI_interfaces = new int[0];
            this.fCachedInterfaces = new String[0];
            this.fPossibleKeys = new String[0];
            return;
        }
        this.fCPI_interfaces = new int[interfaces.length];
        this.fCachedInterfaces = new String[interfaces.length];
        String[] fetchedKeys = new String[interfaces.length];
        boolean succeded = true;
        for (int i = 0; i < interfaces.length; ++i) {
            this.fCPI_interfaces[i] = this.fConstantPool.addClassReference(interfaces[i]);
            DGClassConstant impl = (DGClassConstant)this.fConstantPool.getConstant(this.fCPI_interfaces[i]);
            this.fCachedInterfaces[i] = impl.getClassNameString();
            try {
                fetchedKeys[i] = CompilerSettingsUtility.getKeyFromString(ClassName.getClassName((String)this.fCachedInterfaces[i]).getPackageAndNameString());
                continue;
            }
            catch (InvalidClassNameException e) {
                succeded = false;
                break;
            }
        }
        this.fPossibleKeys = !succeded ? null : fetchedKeys;
    }

    public String[] getInterfaceNames() {
        String[] results = new String[this.fCachedInterfaces.length];
        for (int i = 0; i < this.fCachedInterfaces.length; ++i) {
            results[i] = this.fCachedInterfaces[i];
        }
        return results;
    }

    public boolean inheritsFrom(String interfaceName) {
        for (int i = 0; i < this.fCachedInterfaces.length; ++i) {
            if (!this.fCachedInterfaces[i].equals(interfaceName)) continue;
            return true;
        }
        return false;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.fCPI_interfaces.length);
        for (int i = 0; i < this.fCPI_interfaces.length; ++i) {
            out.writeShort(this.fCPI_interfaces[i]);
        }
    }

    public String[] getPossibleKeys() {
        return this.fPossibleKeys;
    }
}

