/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.methodmatcher.NamedMethodMatcher;
import com.wily.diagnos.cmp.mutate.IMethodMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.transform.AEveryMethodTransformation;
import com.wily.diagnos.cmp.transform.ITracerGroupTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.SubscribeToOneMethodTransformationBuilder;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;

public class SubscribeToOneMethodTransformation
extends AEveryMethodTransformation
implements ITracerGroupTransformation {
    private final TracerGroup fTracerGroup;
    private final IMethodName fMethodName;
    private final IMethodMatcher fMethodMatcher;
    private final String fSubscriberPluginName;

    public SubscribeToOneMethodTransformation(ICompilerLog log, TracerGroup tracerGroup, IMethodName methodName, String subscriberPluginName) {
        super(log);
        this.fTracerGroup = tracerGroup;
        this.fMethodName = methodName;
        this.fMethodMatcher = NamedMethodMatcher.getInstance(methodName);
        this.fSubscriberPluginName = subscriberPluginName;
    }

    @Override
    public TracerGroup getTracerGroup() {
        return this.fTracerGroup;
    }

    public IMethodName getMethodName() {
        return this.fMethodName;
    }

    public IMethodMatcher getMethodMatcher() {
        return this.fMethodMatcher;
    }

    public String getSubscriberPluginName() {
        return this.fSubscriberPluginName;
    }

    @Override
    protected boolean doShouldProcessClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return !ClassSettingsApplier.shouldSkipClassForTracerGroup(this.getLog(), targetClass, this.getTracerGroup()) && this.getTracerGroup().getClassMatcher().IClassMatcher_matches(targetClass);
    }

    @Override
    protected boolean doShouldMutateMethod(DGCompilerSettings settings, IModeledMethod targetMethod) {
        return this.fMethodMatcher.IMethodMatcher_matches(targetMethod);
    }

    @Override
    protected IMutation doGenerateMethodMutation(DGCompilerSettings settings, IMethodMutator mutator, IModeledMethod targetMethod) {
        return mutator.newSubscribeToOneMethodMutation(settings, targetMethod, this.getSubscriberPluginName());
    }

    @Override
    public ITransformationBuilder generateTransformationBuilder(CompilerSettingsBuilder builder) {
        return new SubscribeToOneMethodTransformationBuilder(builder.getTracerGroupBuilder(this.getTracerGroup()), this.getMethodName(), this.getSubscriberPluginName());
    }
}

